%define name yaf
%define version 2.4.0
%define release 2

Summary: Yet Another Flow sensor
Name: %{name}
Version: %{version}
Release: %{release}%{dist}
Group: NetSA
License: GPL
Source: %{name}-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}
Packager: Tony Cebzanov <tonyc@cert.org>
Vendor: http://tools.netsa.cert.org/
Provides: yaf
Requires: glib2 >= 2.6.4
Requires: libfixbuf >= 1.0.0
Requires: libpcap
%if "x1" == "x1"
Requires: pcre >= 7.3
%endif
BuildRequires: glib2-devel >= 2.6.4
BuildRequires: libfixbuf-devel >= 1.0.0
BuildRequires: pkgconfig >= 0.8
%if 1 == 2
BuildRequires: libpcap-devel
BuildRequires: libtool-ltdl-devel
%endif
%if "x1" == "x1"
BuildRequires: pcre-devel >= 7.3
%endif



%description
YAF is Yet Another Flow sensor. It processes packet data from pcap(3) dumpfiles
as generated by tcpdump(1) or via live capture from an interface using pcap(3)
or an Endace DAG card into bidirectional flows, then exports those flows to
IPFIX Collecting Processes or in an IPFIX-based file format. YAF's output can
be used with the NetSA Aggregated Flow (NAF) toolchain.

%package devel
Summary: Static libraries and C header files for yaf
Group: Development/NetSA
Provides: yaf-devel
Requires: %{name} = %{version}
Requires: pkgconfig >= 0.8


%description devel
Static libraries and C header files for yaf.

%prep
%setup -q -n %{name}-%{version}

%build
./configure --host=%{_host} --build=%{_build} --target=%{_target_platform} --program-prefix=%{?_program_prefix} --prefix=%{_prefix} --exec-prefix=%{_exec_prefix} --bindir=%{_bindir} --sbindir=%{_sbindir} --sysconfdir=%{_sysconfdir} --datadir=%{_datadir} --includedir=%{_includedir} --libdir=%{_libdir} --libexecdir=%{_libexecdir} --localstatedir=%{_localstatedir} --sharedstatedir=%{_sharedstatedir} --mandir=%{_mandir} --infodir=%{_infodir} --disable-static  --enable-plugins --enable-applabel
%{__make}

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT%{_bindir}
%makeinstall

mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/init.d/
install --mode=0755 etc/init.d/yaf $RPM_BUILD_ROOT%{_sysconfdir}/init.d/
install --mode=0644 etc/yaf.conf $RPM_BUILD_ROOT%{_sysconfdir}

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-, root, root)
%doc AUTHORS COPYING NEWS README doc/html
%{_bindir}/yaf
%{_bindir}/yafscii
%{_bindir}/yafcollect
%{_bindir}/airdaemon
%{_bindir}/filedaemon
%{_bindir}/getFlowKeyHash
%{_bindir}/yafMeta2Pcap
%{_libdir}/*.so*
%if "x1" == "x1"
%{_libdir}/yaf/*.so*
%{_libdir}/yaf/*.la 
%endif
%{_mandir}/*
%config(noreplace) %{_sysconfdir}/yafApplabelRules.conf
%if "x1" == "x1"
%config(noreplace) %{_sysconfdir}/yafDPIRules.conf
%config(noreplace) %{_sysconfdir}/dhcp_fingerprints.conf
%endif
%if "x" == "x1"
%config(noreplace) %{_sysconfdir}/p0f.fp
%endif
%config(noreplace) %{_sysconfdir}/yaf.conf
%attr(755,root,root) %{_sysconfdir}/init.d/yaf 

%files devel
%defattr(-, root, root)
%{_includedir}/*
%{_libdir}/*.la
%{_libdir}/pkgconfig/*

%changelog
