import sys
import pyfixbuf
import pyfixbuf.cert


def allInOne(filename):
    infomodel = pyfixbuf.InfoModel()
    collector = pyfixbuf.Collector()
    collector.init_file(filename)
    session = pyfixbuf.Session(infomodel)
    buf = pyfixbuf.Buffer(auto=True)
    buf.init_collection(session, collector)

    records = []
    for data in buf:
        if(data.template.scope is not None):
            continue
        records.append(data)

    record = records[0]

    templateLists = [f for f in record if (type(f) == pyfixbuf.STL or type(f) == pyfixbuf.STML)]
    results = []
    for l in templateLists:
        for sub_record in l:
            results += sub_record


if __name__ == '__main__':
    allInOne(sys.argv[1])
