#########################################################################
# Copyright 2013-2022 by Carnegie Mellon University
#
# @OPENSOURCE_HEADER_START@
# Use of the Network Situational Awareness Python support library and
# related source code is subject to the terms of the following licenses:
#
# GNU Lesser Public License (LGPL) Rights pursuant to Version 2.1, February 1999
# Government Purpose License Rights (GPLR) pursuant to DFARS 252.227.7013
#
# NO WARRANTY
#
# ANY INFORMATION, MATERIALS, SERVICES, INTELLECTUAL PROPERTY OR OTHER
# PROPERTY OR RIGHTS GRANTED OR PROVIDED BY CARNEGIE MELLON UNIVERSITY
# PURSUANT TO THIS LICENSE (HEREINAFTER THE "DELIVERABLES") ARE ON AN
# "AS-IS" BASIS. CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY
# KIND, EITHER EXPRESS OR IMPLIED AS TO ANY MATTER INCLUDING, BUT NOT
# LIMITED TO, WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE,
# MERCHANTABILITY, INFORMATIONAL CONTENT, NONINFRINGEMENT, OR ERROR-FREE
# OPERATION. CARNEGIE MELLON UNIVERSITY SHALL NOT BE LIABLE FOR INDIRECT,
# SPECIAL OR CONSEQUENTIAL DAMAGES, SUCH AS LOSS OF PROFITS OR INABILITY
# TO USE SAID INTELLECTUAL PROPERTY, UNDER THIS LICENSE, REGARDLESS OF
# WHETHER SUCH PARTY WAS AWARE OF THE POSSIBILITY OF SUCH DAMAGES.
# LICENSEE AGREES THAT IT WILL NOT MAKE ANY WARRANTY ON BEHALF OF
# CARNEGIE MELLON UNIVERSITY, EXPRESS OR IMPLIED, TO ANY PERSON
# CONCERNING THE APPLICATION OF OR THE RESULTS TO BE OBTAINED WITH THE
# DELIVERABLES UNDER THIS LICENSE.
#
# Licensee hereby agrees to defend, indemnify, and hold harmless Carnegie
# Mellon University, its trustees, officers, employees, and agents from
# all claims or demands made against them (and any related losses,
# expenses, or attorney's fees) arising out of, or relating to Licensee's
# and/or its sub licensees' negligent use or willful misuse of or
# negligent conduct or willful misconduct regarding the Software,
# facilities, or other rights or assistance granted by Carnegie Mellon
# University under this License, including, but not limited to, any
# claims of product liability, personal injury, death, damage to
# property, or violation of any laws or regulations.
#
# Carnegie Mellon University Software Engineering Institute authored
# documents are sponsored by the U.S. Department of Defense under
# Contract FA8721-05-C-0003. Carnegie Mellon University retains
# copyrights in all material produced under this contract. The U.S.
# Government retains a non-exclusive, royalty-free license to publish or
# reproduce these documents, or allow others to do so, for U.S.
# Government purposes only pursuant to the copyright license under the
# contract clause at 252.227.7013.
#
# @OPENSOURCE_HEADER_END@
#
#######################################################################

from pyfixbuf import CERT_PEN, DataType, InfoElement, Semantic, Units, VARLEN


##############################################################################
#  Pre-defined Information Element Lists
#  ======================================
#
#  The YAF-defined Information Elements, CERT PEN 6871.
#
#  NOTE: The following variables will either be removed in a future release or
#  only be available after invoking a function.  Please change your code so it
#  adds these Information Elements to your model by loading them from the
#  pyfixbuf.cert package, as shown here:
#
#      # create your model as normal
#      model = pyfixbuf.InfoModel()
#
#      # add this:
#      import pyfixbuf.cert
#      pyfixbuf.cert.add_elements_to_model(model)
#
#
#  The variables containing lists of Information Elements.
#
#  Give a list as the argument to InfoModel.add_element_list() to add
#  those Information Elements to the InfoModel.
#
#  YAF_LIST and YAF_STATS are necessary for processing the IPFIX
#  streams created by YAF.
#
YAF_LIST = [InfoElement("initialTCPFlags", CERT_PEN, 14, 1, True, True,
                        type=DataType.UINT8, semantic=Semantic.FLAGS),
            InfoElement("unionTCPFlags", CERT_PEN, 15, 1, True, True,
                        type=DataType.UINT8, semantic=Semantic.FLAGS),
            InfoElement("reverseFlowDeltaMilliseconds", CERT_PEN, 21, 4,
                        endian=True, type=DataType.MILLISECONDS,
                        units=Units.MILLISECONDS),
            InfoElement("silkAppLabel", CERT_PEN, 33, 2, endian=True,
                        type=DataType.UINT16),
            InfoElement("osName", CERT_PEN, 36, VARLEN, True,
                        type=DataType.STRING),
            InfoElement("payload", CERT_PEN, 18, VARLEN, True,
                        type=DataType.OCTET_ARRAY),
            InfoElement("osVersion", CERT_PEN, 37, VARLEN, True,
                        type=DataType.STRING),
            InfoElement("firstPacketBanner", CERT_PEN, 38, VARLEN,
                        reversible=True, type=DataType.OCTET_ARRAY),
            InfoElement("secondPacketBanner", CERT_PEN, 39, VARLEN,
                        reversible=True, type=DataType.OCTET_ARRAY),
            InfoElement("flowAttributes", CERT_PEN, 40, 2, True, True,
                        DataType.UINT16),
            InfoElement("osFingerPrint", CERT_PEN, 107, VARLEN, True,
                        type=DataType.STRING),
            InfoElement("yafFlowKeyHash", CERT_PEN, 106, 4, True, True,
                        type=DataType.UINT32)]

YAF_STATS_LIST = [InfoElement("expiredFragmentCount", CERT_PEN, 100, 4,
                              endian=True, type=DataType.UINT32,
                              units=Units.PACKETS,
                              semantic=Semantic.TOTALCOUNTER),
                  InfoElement("assembledFragmentCount", CERT_PEN, 101, 4,
                              endian=True, type=DataType.UINT32,
                              units=Units.PACKETS,
                              semantic=Semantic.TOTALCOUNTER),
                  InfoElement("meanFlowRate", CERT_PEN, 102, 4, endian=True,
                              type=DataType.UINT32),
                  InfoElement("meanPacketRate", CERT_PEN, 103, 4,
                              endian=True, type=DataType.UINT32),
                  InfoElement("flowTableFlushEventCount", CERT_PEN, 104, 4,
                              endian=True, type=DataType.UINT32,
                              semantic=Semantic.TOTALCOUNTER),
                  InfoElement("flowTablePeakCount", CERT_PEN, 105, 4,
                              endian=True, type=DataType.UINT32,
                              semantic=Semantic.TOTALCOUNTER)]

YAF_FLOW_STATS_LIST= [InfoElement("smallPacketCount", CERT_PEN, 500, 4,
                                  endian=True, reversible=True,
                                  type=DataType.UINT32,
                                  semantic=Semantic.TOTALCOUNTER),
                      InfoElement("nonEmptyPacketCount", CERT_PEN, 501, 4,
                                  endian=True, reversible=True,
                                  type=DataType.UINT32,
                                  semantic=Semantic.TOTALCOUNTER),
                      InfoElement("dataByteCount", CERT_PEN, 502, 8,
                                  endian=True, reversible=True,
                                  type=DataType.UINT64,
                                  semantic=Semantic.TOTALCOUNTER),
                      InfoElement("averageInterarrivalTime", CERT_PEN, 503, 8,
                                  endian=True, reversible=True,
                                  type=DataType.UINT64),
                      InfoElement("standardDeviationInterarrivalTime",
                                  CERT_PEN, 504, 8, endian=True,
                                  reversible=True, type=DataType.UINT64),
                      InfoElement("firstNonEmptyPacketSize", CERT_PEN, 505, 2,
                                  endian=True, reversible=True,
                                  type=DataType.UINT16,
                                  semantic=Semantic.QUANTITY),
                      InfoElement("maxPacketSize", CERT_PEN, 506, 2,
                                  endian=True, reversible=True,
                                  type=DataType.UINT16,
                                  semantic=Semantic.QUANTITY),
                      InfoElement("firstEightNonEmptyPacketDirections",
                                  CERT_PEN, 507, 1, endian=True,
                                  reversible=True, type=DataType.UINT8),
                      InfoElement("standardDeviationPayloadLength", CERT_PEN,
                                  508, 2, endian=True, reversible=True,
                                  type=DataType.UINT16),
                      InfoElement("tcpUrgCount", CERT_PEN, 509, 4,
                                  endian=True, reversible=True,
                                  type=DataType.UINT32),
                      InfoElement("largePacketCount", CERT_PEN, 510, 4,
                                  endian=True, reversible=True,
                                  type=DataType.UINT32)]

YAF_HTTP_LIST = [InfoElement("httpServerString", CERT_PEN, 110,
                             type=DataType.STRING),
                 InfoElement("httpUserAgent", CERT_PEN, 111,
                             type=DataType.STRING),
                 InfoElement("httpGet", CERT_PEN, 112,
                             type=DataType.STRING),
                 InfoElement("httpConnection", CERT_PEN, 113,
                             type=DataType.STRING),
                 InfoElement("httpVersion", CERT_PEN, 114,
                             type=DataType.STRING),
                 InfoElement("httpReferer", CERT_PEN, 115,
                             type=DataType.STRING),
                 InfoElement("httpLocation", CERT_PEN, 116,
                             type=DataType.STRING),
                 InfoElement("httpHost", CERT_PEN, 117,
                             type=DataType.STRING),
                 InfoElement("httpContentLength", CERT_PEN, 118,
                             type=DataType.STRING),
                 InfoElement("httpAge", CERT_PEN, 119,
                             type=DataType.STRING),
                 InfoElement("httpAccept", CERT_PEN, 120,
                             type=DataType.STRING),
                 InfoElement("httpAcceptLanguage", CERT_PEN, 121,
                             type=DataType.STRING),
                 InfoElement("httpContentType", CERT_PEN, 122,
                             type=DataType.STRING),
                 InfoElement("httpResponse", CERT_PEN, 123,
                             type=DataType.STRING),
                 InfoElement("httpCookie", CERT_PEN, 220,
                             type=DataType.STRING),
                 InfoElement("httpSetCookie", CERT_PEN, 221,
                             type=DataType.STRING),
                 InfoElement("httpAuthorization", CERT_PEN, 252,
                             type=DataType.STRING),
                 InfoElement("httpVia", CERT_PEN, 253,
                             type=DataType.STRING),
                 InfoElement("httpX-Forwarded-For", CERT_PEN, 254,
                             type=DataType.STRING),
                 InfoElement("httpRefresh", CERT_PEN, 256,
                             type=DataType.STRING),
                 InfoElement("httpIMEI", CERT_PEN, 257,
                             type=DataType.STRING),
                 InfoElement("httpIMSI", CERT_PEN, 258,
                             type=DataType.STRING),
                 InfoElement("httpMSISDN", CERT_PEN, 259,
                             type=DataType.STRING),
                 InfoElement("httpSubscriber", CERT_PEN, 260,
                             type=DataType.STRING),
                 InfoElement("httpExpires", CERT_PEN, 255,
                             type=DataType.STRING),
                 InfoElement("httpAcceptCharset", CERT_PEN, 261,
                             type=DataType.STRING),
                 InfoElement("httpAcceptEncoding", CERT_PEN, 262,
                             type=DataType.STRING),
                 InfoElement("httpAllow", CERT_PEN, 263,
                             type=DataType.STRING),
                 InfoElement("httpDate", CERT_PEN, 264,
                             type=DataType.STRING),
                 InfoElement("httpExpect", CERT_PEN, 265,
                             type=DataType.STRING),
                 InfoElement("httpFrom", CERT_PEN, 266,
                             type=DataType.STRING),
                 InfoElement("httpProxyAuthentication", CERT_PEN, 267,
                             type=DataType.STRING),
                 InfoElement("httpUpgrade", CERT_PEN, 268,
                             type=DataType.STRING),
                 InfoElement("httpWarning", CERT_PEN, 269,
                             type=DataType.STRING),
                 InfoElement("httpDNT", CERT_PEN, 270,
                             type=DataType.STRING),
                 InfoElement("httpX-Forwarded-Proto", CERT_PEN, 271,
                             type=DataType.STRING),
                 InfoElement("httpX-Forwarded-Host", CERT_PEN, 272,
                             type=DataType.STRING),
                 InfoElement("httpX-Forwarded-Server", CERT_PEN, 273,
                             type=DataType.STRING),
                 InfoElement("httpX-DeviceID", CERT_PEN, 274,
                             type=DataType.STRING),
                 InfoElement("httpX-Profile", CERT_PEN, 275,
                             type=DataType.STRING),
                 InfoElement("httpLastModified", CERT_PEN, 276,
                             type=DataType.STRING),
                 InfoElement("httpContentEncoding", CERT_PEN, 277,
                             type=DataType.STRING),
                 InfoElement("httpContentLanguage", CERT_PEN, 278,
                             type=DataType.STRING),
                 InfoElement("httpContentLocation", CERT_PEN, 279,
                             type=DataType.STRING),
                 InfoElement("httpX-UA-Compatible", CERT_PEN, 280,
                             type=DataType.STRING)]

YAF_SLP_LIST = [InfoElement("slpVersion", CERT_PEN, 128, 1, endian=True,
                            type=DataType.UINT8),
                InfoElement("slpMessageType", CERT_PEN, 129, 1, endian=True,
                            type=DataType.UINT8),
                InfoElement("slpString", CERT_PEN, 130,
                            type=DataType.STRING)]

YAF_FTP_LIST = [InfoElement("ftpReturn", CERT_PEN, 131,
                            type=DataType.STRING),
                InfoElement("ftpUser", CERT_PEN, 132,
                            type=DataType.STRING),
                InfoElement("ftpPass", CERT_PEN, 133,
                            type=DataType.STRING),
                InfoElement("ftpType", CERT_PEN, 134,
                            type=DataType.STRING),
                InfoElement("ftpRespCode", CERT_PEN, 135,
                            type=DataType.STRING)]

YAF_IMAP_LIST = [InfoElement("imapCapability", CERT_PEN, 136,
                             type=DataType.STRING),
                 InfoElement("imapLogin", CERT_PEN, 137,
                             type=DataType.STRING),
                 InfoElement("imapStartTLS", CERT_PEN, 138,
                             type=DataType.STRING),
                 InfoElement("imapAuthenticate", CERT_PEN, 139,
                             type=DataType.STRING),
                 InfoElement("imapCommand", CERT_PEN, 140,
                             type=DataType.STRING),
                 InfoElement("imapExists", CERT_PEN, 141,
                             type=DataType.STRING),
                 InfoElement("imapRecent", CERT_PEN, 142,
                             type=DataType.STRING)]

YAF_RTSP_LIST = [InfoElement("rtspURL", CERT_PEN, 143,
                             type=DataType.STRING),
                 InfoElement("rtspVersion", CERT_PEN, 144,
                             type=DataType.STRING),
                 InfoElement("rtspReturnCode", CERT_PEN, 145,
                             type=DataType.STRING),
                 InfoElement("rtspContentLength", CERT_PEN, 146,
                             type=DataType.STRING),
                 InfoElement("rtspCommand", CERT_PEN, 147,
                             type=DataType.STRING),
                 InfoElement("rtspContentType", CERT_PEN, 148,
                             type=DataType.STRING),
                 InfoElement("rtspTransport", CERT_PEN, 149,
                             type=DataType.STRING),
                 InfoElement("rtspCSeq", CERT_PEN, 150,
                             type=DataType.STRING),
                 InfoElement("rtspLocation", CERT_PEN, 151,
                             type=DataType.STRING),
                 InfoElement("rtspPacketsReceived", CERT_PEN, 152,
                             type=DataType.STRING),
                 InfoElement("rtspUserAgent", CERT_PEN, 153,
                             type=DataType.STRING),
                 InfoElement("rtspJitter", CERT_PEN, 154,
                             type=DataType.STRING)]

YAF_SIP_LIST = [InfoElement("sipInvite", CERT_PEN, 155,
                            type=DataType.STRING),
                InfoElement("sipCommand", CERT_PEN, 156,
                            type=DataType.STRING),
                InfoElement("sipVia", CERT_PEN, 157,
                            type=DataType.STRING),
                InfoElement("sipMaxForwards", CERT_PEN, 158,
                            type=DataType.STRING),
                InfoElement("sipAddress", CERT_PEN, 159,
                            type=DataType.STRING),
                InfoElement("sipContentLength", CERT_PEN, 160,
                            type=DataType.STRING),
                InfoElement("sipUserAgent", CERT_PEN, 161,
                            type=DataType.STRING)]

YAF_SMTP_LIST = [InfoElement("smtpHello", CERT_PEN, 162,
                             type=DataType.STRING),
                 InfoElement("smtpFrom", CERT_PEN, 163,
                             type=DataType.STRING),
                 InfoElement("smtpTo", CERT_PEN, 164,
                             type=DataType.STRING),
                 InfoElement("smtpContentType", CERT_PEN, 165,
                             type=DataType.STRING),
                 InfoElement("smtpSubject", CERT_PEN, 166,
                             type=DataType.STRING),
                 InfoElement("smtpFilename", CERT_PEN, 167,
                             type=DataType.STRING),
                 InfoElement("smtpContentDisposition", CERT_PEN, 168,
                             type=DataType.STRING),
                 InfoElement("smtpResponse", CERT_PEN, 169,
                             type=DataType.STRING),
                 InfoElement("smtpEnhanced", CERT_PEN, 170,
                             type=DataType.STRING),
                 InfoElement("smtpSize", CERT_PEN, 222,
                             type=DataType.STRING),
                 InfoElement("smtpDate", CERT_PEN, 251,
                             type=DataType.STRING)]


YAF_DNS_LIST = [InfoElement("dnsQueryResponse", CERT_PEN, 174, 1,
                            endian=True, type=DataType.UINT8),
                InfoElement("dnsQRType", CERT_PEN, 175, 2, endian=True,
                            type=DataType.UINT16),
                InfoElement("dnsAuthoritative", CERT_PEN, 176, 1,
                            endian=True, type=DataType.UINT8),
                InfoElement("dnsNXDomain", CERT_PEN, 177, 1, endian=True,
                            type=DataType.UINT8),
                InfoElement("dnsRRSection", CERT_PEN, 178, 1, endian=True,
                            type=DataType.UINT8),
                InfoElement("dnsQName", CERT_PEN, 179,
                            type=DataType.STRING),
                InfoElement("dnsCName", CERT_PEN, 180,
                            type=DataType.STRING),
                InfoElement("dnsMXPreference", CERT_PEN, 181, 2,endian=True,
                            type=DataType.UINT16),
                InfoElement("dnsMXExchange", CERT_PEN, 182,
                            type=DataType.STRING),
                InfoElement("dnsNSDName", CERT_PEN, 183,
                            type=DataType.STRING),
                InfoElement("dnsPTRDName", CERT_PEN, 184,
                            type=DataType.STRING),
                InfoElement("dnsTTL", CERT_PEN, 199, 4, endian=True,
                            type=DataType.UINT32),
                InfoElement("dnsTXTData", CERT_PEN, 208,
                            type=DataType.STRING),
                InfoElement("dnsSOASerial", CERT_PEN, 209, 4, endian=True,
                            type=DataType.UINT32),
                InfoElement("dnsSOARefresh", CERT_PEN, 210, 4, endian=True,
                            type=DataType.UINT32),
                InfoElement("dnsSOARetry", CERT_PEN, 211, 4, endian=True,
                            type=DataType.UINT32),
                InfoElement("dnsSOAExpire", CERT_PEN, 212, 4, endian=True,
                            type=DataType.UINT32),
                InfoElement("dnsSOAMinimum", CERT_PEN, 213, 4, endian=True,
                            type=DataType.UINT32),
                InfoElement("dnsSOAMName", CERT_PEN, 214,
                            type=DataType.STRING),
                InfoElement("dnsSOARName", CERT_PEN, 215,
                            type=DataType.STRING),
                InfoElement("dnsSRVPriority", CERT_PEN, 216, 2, endian=True,
                            type=DataType.UINT16),
                InfoElement("dnsSRVWeight", CERT_PEN, 217, 2, endian=True,
                            type=DataType.UINT16),
                InfoElement("dnsSRVPort", CERT_PEN, 218, 2, endian=True,
                            type=DataType.UINT16),
                InfoElement("dnsSRVTarget", CERT_PEN, 219,
                            type=DataType.STRING),
                InfoElement("dnsID", CERT_PEN, 226, 2, endian=True,
                            type=DataType.UINT16),
                InfoElement("dnsAlgorithm", CERT_PEN, 227, 1, endian=True,
                            type=DataType.UINT8),
                InfoElement("dnsKeyTag", CERT_PEN, 228, 2, endian=True,
                            type=DataType.UINT16),
                InfoElement("dnsSigner", CERT_PEN, 229,
                            type=DataType.STRING),
                InfoElement("dnsSignature", CERT_PEN, 230,
                            type=DataType.OCTET_ARRAY),
                InfoElement("dnsDigest", CERT_PEN, 231,
                            type=DataType.OCTET_ARRAY),
                InfoElement("dnsPublicKey", CERT_PEN, 232,
                            type=DataType.OCTET_ARRAY),
                InfoElement("dnsSalt", CERT_PEN, 233,
                            type=DataType.OCTET_ARRAY),
                InfoElement("dnsHashData", CERT_PEN, 234,
                            type=DataType.OCTET_ARRAY),
                InfoElement("dnsIterations", CERT_PEN, 235, 2, endian=True,
                            type=DataType.UINT16),
                InfoElement("dnsSignatureExpiration", CERT_PEN, 236, 4,
                            endian=True, type=DataType.UINT32),
                InfoElement("dnsSignatureInception", CERT_PEN, 237, 4,
                            endian=True, type=DataType.UINT32),
                InfoElement("dnsDigestType", CERT_PEN, 238, 1, endian=True,
                            type=DataType.UINT8),
                InfoElement("dnsLabels", CERT_PEN, 239, 1, endian=True,
                            type=DataType.UINT8),
                InfoElement("dnsTypeCovered", CERT_PEN, 240, 2, endian=True,
                            type=DataType.UINT16),
                InfoElement("dnsFlags", CERT_PEN, 241, 2, endian=True,
                            type=DataType.UINT16, semantic=Semantic.FLAGS)]

YAF_SSL_LIST = [InfoElement("sslCipher", CERT_PEN, 185, 4, endian=True,
                            type=DataType.UINT32),
                InfoElement("sslClientVersion", CERT_PEN, 186, 1,
                            endian=True, type=DataType.UINT8),
                InfoElement("sslServerCipher", CERT_PEN, 187, 4,endian=True,
                            type=DataType.UINT32),
                InfoElement("sslCompressionMethod", CERT_PEN, 188, 1,
                            endian=True, type=DataType.UINT8),
                InfoElement("sslCertVersion", CERT_PEN, 189, 1, endian=True,
                            type=DataType.UINT8),
                InfoElement("sslCertSignature", CERT_PEN, 190,
                            type=DataType.OCTET_ARRAY),
                InfoElement("sslCertIssuerCountryName", CERT_PEN, 191,
                            type=DataType.STRING),
                InfoElement("sslCertIssuerOrgName", CERT_PEN, 192,
                            type=DataType.STRING),
                InfoElement("sslCertIssuerOrgUnitName", CERT_PEN, 193,
                            type=DataType.STRING),
                InfoElement("sslCertIssuerZipCode", CERT_PEN, 194,
                            type=DataType.STRING),
                InfoElement("sslCertIssuerState", CERT_PEN, 195,
                            type=DataType.STRING),
                InfoElement("sslCertIssuerCommonName", CERT_PEN, 196,
                            type=DataType.STRING),
                InfoElement("sslCertIssuerLocalityName", CERT_PEN, 197,
                            type=DataType.STRING),
                InfoElement("sslCertIssuerStreetAddress", CERT_PEN, 198,
                            type=DataType.STRING),
                InfoElement("sslCertSubCountryName", CERT_PEN, 200,
                            type=DataType.STRING),
                InfoElement("sslCertSubOrgName", CERT_PEN, 201,
                            type=DataType.STRING),
                InfoElement("sslCertSubOrgUnitName", CERT_PEN, 202,
                            type=DataType.STRING),
                InfoElement("sslCertSubZipCode", CERT_PEN, 203,
                            type=DataType.STRING),
                InfoElement("sslCertSubState", CERT_PEN, 204,
                            type=DataType.STRING),
                InfoElement("sslCertSubCommonName", CERT_PEN, 205,
                            type=DataType.STRING),
                InfoElement("sslCertSubLocalityName", CERT_PEN, 206,
                            type=DataType.STRING),
                InfoElement("sslCertSubStreetAddress", CERT_PEN, 207,
                            type=DataType.STRING),
                InfoElement("sslCertSerialNumber", CERT_PEN, 244,
                            type=DataType.OCTET_ARRAY),
                InfoElement("sslObjectType", CERT_PEN, 245, 1,
                            endian=True, type=DataType.UINT8),
                InfoElement("sslObjectValue", CERT_PEN, 246,
                            type=DataType.OCTET_ARRAY),
                InfoElement("sslCertValidityNotBefore", CERT_PEN, 247,
                            type=DataType.STRING),
                InfoElement("sslCertValidityNotAfter", CERT_PEN, 248,
                            type=DataType.STRING),
                InfoElement("sslPublicKeyAlgorithm", CERT_PEN, 249,
                            type=DataType.OCTET_ARRAY),
                InfoElement("sslPublicKeyLength", CERT_PEN, 250, 2,
                            endian=True, type=DataType.UINT16),
                InfoElement("sslRecordVersion", CERT_PEN, 288, 2,
                            endian=True, type=DataType.UINT16)]

YAF_DPI_LIST = [InfoElement("mysqlUsername", CERT_PEN, 223,
                            type=DataType.STRING),
                InfoElement("mysqlCommandCode", CERT_PEN, 224, 1,
                            endian=True, type=DataType.UINT8),
                InfoElement("mysqlCommandText", CERT_PEN, 225,
                            type=DataType.STRING),
                InfoElement("pop3TextMessage", CERT_PEN, 124,
                            type=DataType.STRING),
                InfoElement("ircTextMessage", CERT_PEN, 125,
                            type=DataType.STRING),
                InfoElement("tftpFilename", CERT_PEN, 126,
                            type=DataType.STRING),
                InfoElement("tftpMode", CERT_PEN, 127,
                            type=DataType.STRING),
                InfoElement("sshVersion", CERT_PEN, 171,
                            type=DataType.STRING),
                InfoElement("nntpResponse", CERT_PEN, 172,
                            type=DataType.STRING),
                InfoElement("nntpCommand", CERT_PEN, 173,
                            type=DataType.STRING),
                InfoElement("dhcpFingerPrint", CERT_PEN, 242, reversible=True),
                InfoElement("dhcpVendorCode", CERT_PEN, 243, reversible=True),
                InfoElement("dnp3SourceAddress", CERT_PEN, 281, 2, endian=True,
                            type=DataType.UINT16),
                InfoElement("dnp3DestinationAddress", CERT_PEN, 282, 2,
                            endian=True, type=DataType.UINT16),
                InfoElement("dnp3Function", CERT_PEN, 283, 1, endian=True,
                            type=DataType.UINT8),
                InfoElement("dnp3ObjectData", CERT_PEN, 284,
                            type=DataType.OCTET_ARRAY),
                InfoElement("modbusData", CERT_PEN, 285,
                            type=DataType.OCTET_ARRAY),
                InfoElement("ethernetIPData", CERT_PEN, 286,
                            type=DataType.OCTET_ARRAY),
                InfoElement("rtpPayloadType", CERT_PEN, 287, 1,
                            endian=True, reversible=True, type=DataType.UINT8)]

# Local Variables:
# indent-tabs-mode:nil
# fill-column:78
# End:
