pyfixbuf
========

pyfixbuf is a Python API for [libfixbuf][], an implementation of the IP Flow
Information Export (IPFIX) protocol used for building collecting and
exporting processes.  pyfixbuf may be used to write applications, often called
mediators, that collect and/or export IPFIX. Mediators are useful in
modifying, filtering, or adding to the content of the message before
forwarding to another IPFIX collection point, or in converting IPFIX to
another format (text, database, JSON, etc.).

libfixbuf is a compliant implementation of the IPFIX Protocol, as defined in
the following RFCs:

- [RFC 7011][rfc7011]: Specification of the IPFIX Protocol for the Exchange of Flow Information
- [RFC 7012][rfc7012]: Information Model for IP Flow Information Export
- [RFC 5103][rfc5103]: Bidirectional Flow Export using IPFIX
- [RFC 5610][rfc5610]: Exporting Type Information for IPFIX Information Elements
- [RFC 6313][rfc6313]: Export of Structured Data in IPFIX

libfixbuf, as well as pyfixbuf, supports UDP and TCP as transport protocols.
It also supports operation as an IPFIX file writer or IPFIX file reader.

  [libfixbuf]: https://tools.netsa.cert.org/fixbuf/index.html
  [rfc5103]:   https://tools.ietf.org/html/rfc5103
  [rfc5610]:   https://tools.ietf.org/html/rfc5610
  [rfc6313]:   https://tools.ietf.org/html/rfc6313
  [rfc7011]:   https://tools.ietf.org/html/rfc7011
  [rfc7012]:   https://tools.ietf.org/html/rfc7012


Prerequisites
=============

Python
------

pyfixbuf is compatible with Python 3.3 or later as well as the legacy versions
Python 2.6 and 2.7.  Since some OSes distribute header files and development
libraries in a separate package, ensure those files are installed by checking
for the `python-config` utility:

        type -a python-config

### ipaddress module ###

Users of Python 2.6 or 2.7 should install the __ipaddress__ module through
`pypi` or from <https://github.com/phihag/ipaddress>.  The [ipaddress][]
module is standard in Python 3.3 and later.

  [ipaddress]: https://docs.python.org/3/library/ipaddress.html


libfixbuf
---------

To build pyfixbuf, an installed version of [libfixbuf-2.2][libfixbuf] or later
(including libfixbuf-3.x) is required.  This document assumes libfixbuf was
installed with a prefix of `/usr/local` so that the library is
`/usr/local/lib/libfixbuf.so`.

Ensure the development libraries and headers for libfixbuf are present, since
sometimes those are in a separate package.  Required files include
`/usr/local/lib/pkgconfig/libfixbuf.pc`, `/usr/local/include/fixbuf/public.h`,
and a library similar to `/usr/local/lib/libfixbuf.so.3.2.0` though the
numbers may be different.

Check to see if the `pkg-config` tool can find libfixbuf:

        pkg-config --modversion libfixbuf

If it reports an error, append `/usr/local/lib/pkgconfig` to the
`PKG_CONFIG_PATH` environment variable (using your prefix in place of
`/usr/local`).  The `PKG_CONFIG_PATH` should contain the directory containing
the `libfixbuf.pc` file.


C Compiler
----------

pyfixbuf includes C code that must be compiled.  You need a C compiler and
a functioning development environment.


Building
========

Building and installing pyfixbuf is done using the standard `setup.py`
mechanism.  The following commands should suffice in most cases to install
pyfixbuf with the other Python modules:

        python setup.py build
        sudo python setup.py install

You may need to use the `-E` option to `sudo` to preserve the
`PKG_CONFIG_PATH` environment variable when installing.  Alternatively:

        sudo /bin/sh -c PKG_CONFIG_PATH="$PKG_CONFIG_PATH"' python setup.py install'

To install pyfixbuf in a separate location, use

        python setup.py build
        python setup.py install --prefix=/tmp/test

If you install pyfixbuf in a non-standard location, you may need to append
`/tmp/test/lib/python<VERSION>/site-packages` to your `PYTHONPATH`
environment variable so Python can find the pyfixbuf module.

To remove any temporary files after installing the module, use

        python setup.py clean --all

To get more help on `setup.py`, run

        python setup.py --help-commands

Note that the `PKG_CONFIG_PATH` environment variable may need to be set even
though you are only accessing the help.


For Developers
==============

The remainder of this document is targeted to developers.

Running the Tests
-----------------

To test the pyfixbuf code, use

        python setup.py check

The tests may also be run outside of `setup.py` by using the following:

        PYTHONPATH=build/lib.macosx-10.14-x86_64-3.6/pyfixbuf/test:build/lib.macosx-10.14-x86_64-3.6 \
          python3.6 -m unittest -f pyfixtest

Where `macosx-10.14-x86_64` reflects the host's OS and architecture and `3.6`
is the Python version.

The latter approach to running tests has the advantage that you can limit
tests to a single class or function which is useful when tracking down a bug,
and if you pass the `-v` flag you can see the results for each test.  It has
the disadvantage that it does not ensure the files in the `build` directory
are up to date.

        PYTHONPATH=build/lib.macosx-10.14-x86_64-3.6/pyfixbuf/test:build/lib.macosx-10.14-x86_64-3.6 \
          python3.6 -m unittest -v -f pyfixtest.TestInfoElement

        PYTHONPATH=build/lib.macosx-10.14-x86_64-3.6/pyfixbuf/test:build/lib.macosx-10.14-x86_64-3.6 \
          python3.6 -m unittest -f pyfixtest.TestInfoElement.testInfoElementBasicConstruction


Building the Documentation
--------------------------

To build the documentation, you must have [Sphinx][] and `pdflatex` installed.
Sphinx 2.2.11 is known to work.

Build HTML the documentation with

        python setup.py gen_doc_html

You may browse it from the `doc/html` directory.

Build the `pyfixbuf-0.9.0.pdf` file using

        python setup.py gen_doc_pdf

  [Sphinx]: https://www.sphinx-doc.org/en/master/


Creating a Distribution
-----------------------

To create a source distribution, run

        python setup.py sdist

The distribution is created in the `dist` directory.

The source distribution will only contain the generated HTML documentation if
you explicitly create it first:

        python setup.py gen_doc_html sdist

To get create a NetSA distribution, run:

        python setup.py gen_doc_html netsa_dist

The generated source distribution and a tarball containing web pages are
stored in the `dist` directory.
