Table of Contents
=================

1. Introduction
2. File Descriptions
   1. IPFinder.py
   2. IPFinder_utils.py
   3. dnsQNameFinder.py
   4. dnsQNameFinder_utils.py
   5. dump_ipfix_metadata.py
   6. list_iterator.py
   7. nmsg_to_pipeline.py
   8. portMismatch.py
   9. portMismatch_utils.py
   10. sample_blind_listener.py
   11. sample_collector.py
   12. sample_exporter.py
   13. sample_exporter_collector.py
   14. sample_exporter_collector_blind.py
   15. sample_listener.py
   16. sample_mediator.py
   17. sample_mpls_collector.py
   18. sample_net_exporter.py
   19. shared_utils.py
   20. time_utils.py
   21. yaf_mediator.py
   22. yaf_mediator_new.py


Introduction
============

This directory contains sample programs that demonstrate the use of
pyfixbuf.

File Descriptions
=================

A description for each file in this directory follows.

IPFinder.py
-----------

A program to find IPFIX records that match user-provided IP addresses.

Usage:

    IPFinder.py
        {--input INPUT_FILE_OR_DIR | --in INPUT_FILE_OR_DIR}
        {--ip IP | --ipset IPSET_FILE}
        {--sip | --dip | --anyIP}
        {--count | --outfile OUTPUT | --outfields OUTFIELD [OUTFIELD...]}
        [--delim DELIM]

    IPFinder.py {--help | -h}

The required --input switch, which may be abbreviated --in, names a
single IPFIX file or a directory containing IPFIX files.  If the
argument is "-", the program reads from the standard input.

Either --ip or --ipset must be given to specify the IPv4 addresses to
search for.  The --ip switch takes a single IP address as an argument.
The --ipset switch, which is only available when the silk module is
present, takes the name of an IPset file from which the IPs to match
are read.

One of --sip, --dip, or --anyIP must be given to tell IPFinder.py
whether to match on the value in the sourceIPv4Address information
element, the destinationIPv4Address IE, or both IEs, respectively.

Exactly one of --count, --outfile, --outfields must be specified.

The --count switch prints the number of matching records.

The --outfile switch names an IPFIX file to which the IPFIX records
matching the IP address(es) are written.  An argument of "-" writes to
the standard output.

The --outfields switches accepts one or more arguments that name
Information Elements.  For records matching an IP address, the values
of those fields are printed as text to the standard output.

The --delim switch specifies the delimiter printed between the values
specified by --outfields.  If not specified, the delimiter is "|".

The --help switch prints a summary of the program's usage.


IPFinder_utils.py
-----------------

A file containing supporting functions used by IPFinder.py.


dnsQNameFinder.py
-----------------

A program to find IPFIX records that match DNS query names.

Usage:

    dnsQNameFinder.py
        {--input INPUT_FILE_OR_DIR | --in INPUT_FILE_OR_DIR}
        {--dnsqfile DNSQFILE | --dnsq DNSQNAME}
        {--outfile OUTPUT | --outfields OUTFIELD [OUTFIELD...]}
        [--delim DELIM]

    dnsQNameFinder.py {--help | -h}

The required --input switch, which may be abbreviated --in, names a
single IPFIX file or a directory containing IPFIX files.  If the
argument is "-", the program reads from the standard input.

Either --dnsqfile or --dnsq must be given.  The --dnsqfile switch
takes a text file as an argument, where each line contains a DNS query
name to search for.  The --dnsq switch takes a single DNS query name
to search for.

Exactly one of --outfile or --outfields must be specified.

The --outfile switch names an IPFIX file to which the IPFIX records
containing one of DNS query names are written.  An argument of "-"
writes to the standard output.

The --outfields switches accepts one or more arguments that name
Information Elements.  For records matching a DNS query name, the
values of those fields are printed as text to the standard output.

The --delim switch specifies the delimiter printed between the values
specified by --outfields.  If not specified, the delimiter is "|".

The --help switch prints a summary of the program's usage.


dnsQNameFinder_utils.py
-----------------------

A file containing supporting functions used by dnsQNameFinder.py.


dump_ipfix_metadata.py
----------------------

A program to print a textual summary of the structured data (lists) in
an IPFIX file.

Usage:

    dump_ipfix_metadata.py
        --input INPUT_FILE_OR_DIR
        [--yaf] [--screen] [--fpaths-fieldspec]
        [--tree] [--fpaths] [--fields]

    dump_ipfix_metadata.py {--help | -h}

The required --input switch names a single IPFIX file or a directory
containing IPFIX files.  If the argument is "-", the program reads
from the standard input.

The output is determined by the --tree, --fpaths, and --fields
switches.  The presence of at least one of these switches causes only
that output (or those outputs) to be generated.  If none of the
switches are specified, all the outputs are generated.  Each of the
outputs is written to a separate file in current directory unless the
--screen switch is given, in which case the output is written to the
standard output.  When writing to a file, any previous file with the
same name is overwritten.

The --tree switch produces an ASCII tree showing how the templates are
used.  By default the tree is written to a file named
"tmpl_hierarchy.txt".  Sample output from YAF looks like:

    Template hierarchy:
    b505
        |--ce00
            |--cf00
                |--ce01
                |--ce02
                |--ce03
                |--ce04
                |--ce05
                |--ce06
                |--ce07
                |--ce08
                |--ce09
    b305
        |--c500
        |--ce00
            |--cf00
                |--ce01
                |--ce02
                |--ce03
                |--ce04
                |--ce05
                |--ce06
                |--ce07
                |--ce08
                |--ce09
        |--c003
        |--c206
        |--c600

The --fpaths switch computes all the paths (through the lists) to an
information element in the input.  It then inverts the data and
presents it sorted by the element, with one line for each unique path
to the element.  By default, the output is written to a file named
"field_paths.txt".  Selected lines from the output are:

    httpUserAgent: b311 - c600 - basicList (1) - httpUserAgent
    httpVersion: b311 - c600 - basicList (13) - httpVersion
    paddingOctets: b311 - ca0a - ca0b - ce14 - paddingOctets
    paddingOctets: b311 - ca0a - ca0b - paddingOctets
    reverseUnionTCPFlags: b311 - c013 - reverseUnionTCPFlags
    sourceIPv4Address: b301 - sourceIPv4Address
    sourceIPv4Address: b311 - sourceIPv4Address
    sourceTransportPort: b301 - sourceTransportPort
    sourceTransportPort: b311 - sourceTransportPort
    sslCertSerialNumber: b311 - ca0a - ca0b - sslCertSerialNumber
    sslCertSignature: b311 - ca0a - ca0b - sslCertSignature
    sslObjectType: b311 - ca0a - ca0b - ce14 - sslObjectType
    sslObjectValue: b311 - ca0a - ca0b - ce14 - sslObjectValue
    sslServerName: b311 - ca0a - sslServerName
    unionTCPFlags: b301 - c003 - unionTCPFlags
    unionTCPFlags: b311 - c013 - unionTCPFlags

The sourceIPv4Address element appears in both the templates for
uni-directional (b301) and bi-directional (b311) flows.  Note that the
reverseUnionTCPFlags only appears in bi-directional flows.  The deep
packet inspection data also requires bi-directional flow records.

The --fields switch prints the list of information elements found in
the top-level record and then a list of deep packet inspection
template IDs and the fields those templates contain.  By default the
output is written to a file named "fields_in_tmpls.txt".  Selected
lines from the output are:

    Top-level Fields:
        silkAppLabel
        sourceTransportPort
        destinationIPv4Address
        reverseFlowDeltaMilliseconds
    DPI Templates and Fields:
        c600
            basicList(15): httpSetCookie
            basicList(0): httpServerString
            basicList(10): httpAcceptLanguage
            basicList(1): httpUserAgent
        c003
            tcpSequenceNumber
            initialTCPFlags
            unionTCPFlags
        c013
            reverseTcpSequenceNumber
            tcpSequenceNumber
            unionTCPFlags
            reverseUnionTCPFlags
            reverseInitialTCPFlags
            initialTCPFlags

The numbers following the basicList are do the element being repeated
within the template.

The optional --screen switch causes the output to be written to the
standard output instead of to specific files.

The optional --yaf switch changes the output of --fpaths so the string
"top" is used in place of the top-level template IDs (which were b301
and b311 in the sample output above).  For example, the paddingOctets
lines from above change to:

    paddingOctets: top - ca0a - ca0b - ce14 - paddingOctets
    paddingOctets: top - ca0a - ca0b - paddingOctets

The optional --fpaths-fieldspec switch changes the output of --fpaths
to use a slash ("/") between each level and use decimal for the
template IDs.  For example, the paddingOctets lines from above change
to:

    paddingOctets: ipfix:51722/51723/52756/paddingOctets
    paddingOctets: ipfix:51722/51723/paddingOctets

The --help switch prints a summary of the program's usage.


list_iterator.py
----------------

A program to print the template IDs used in subTemplateMultiLists and
subTemplateLists.

Usage:

    list_iterator.py
        {--input INPUT_FILE_OR_DIR | --in INPUT_FILE_OR_DIR}

    list_iterator.py {--help | -h}

The required --input switch, which may be abbreviated --in, names a
single IPFIX file or a directory containing IPFIX files.  If the
argument is "-", the program reads from the standard input.

The --help switch prints a summary of the program's usage.

The program reads the IPFIX file(s) and for each record prints its
record number ("Record 1:", "Record 2:", ...) and the template IDs
used by any subTemplateMultiLists and subTemplateLists on that record,
recursing down each list.  The template IDs are printed each time they
are used on a record which may produce duplicate entries for a record.


nmsg_to_pipeline.py
-------------------

A program to generate IPFIX records containing a DNS-related fields.

Usage:

    nmsg_to_pipeline.py INPUT_NMSG_CSV_FILE OUTPUT_IPFIX_FILE

    nmsg_to_pipeline.py INPUT_NMSG_CSV_FILE ADDRESS PORT

    nmsg_to_pipeline.py {--help | -h}

nmsg_to_pipeline.py reads a text file where each line contains the
comma-separated fields domain name, DNS record type, DNS time-to-live,
and one or more response IPs.  When the DNS record type is either 1 or
28 (IPv4 or IPv6 address record), the fields on each line are used to
generate an IPFIX record that is written to an output IPFIX file or
exported to an address and port over TCP.  (Multiple records are
generated for a line when the line contains multiple IP addresses.)

Sample input to the program is

    express.cites.example.com.,2,29280,192.168.0.62
    dns1.example.com.,1,35038,192.168.0.63,192.168.1.63
    dns1.cso.example.com.,1,11208,192.168.0.64
    dns2.cso.example.com.,28,126,2011:db8::41

The first argument to the program is the CSV file.  Use "-" to read
from the standard input.

If there are only two arguments, the second argument is used as the
name of the IPFIX output file.  Use "-" to write to the standard
output.

If there are three arguments, the second and third arguments are the
address and port to which the IPFIX records are written.  The
transport always uses TCP.


portMismatch.py
---------------

A program to find IPFIX records where the silkAppLabel value is
different than either the source or destination port.

Usage:

    portMismatch.py
        {--input INPUT_FILE_OR_DIR | --in INPUT_FILE_OR_DIR}
        {--count | --outfile OUTPUT | --outfields OUTFIELD [OUTFIELD...]}
        [--delim DELIM]

    portMismatch.py {--help | -h}

The required --input switch, which may be abbreviated --in, names a
single IPFIX file or a directory containing IPFIX files.  If the
argument is "-", the program reads from the standard input.

Exactly one of --count, --outfile, or --outfields must be specified.

The --count switch tells the program to print the number of records
where the silkAppLabel does not match a port number.

The --outfile switch names an IPFIX file to which the mis-matched
records are written.  An argument of "-" writes to the standard
output.

The --outfields switches accepts one or more arguments that name
Information Elements.  For mismatched records, the values of those
fields are printed as text to the standard output.

The --delim switch specifies the delimiter printed between the values
specified by --outfields.  If not specified, the delimiter is "|".

The --help switch prints a summary of the program's usage.


portMismatch_utils.py
---------------------

A file containing supporting functions used by portMismatch.py.


sample_blind_listener.py
------------------------

A program to listen for network connections from an IPFIX exporter and
write the records to a text file.

Usage:

    sample_listener.py ADDRESS PORT TRANSPORT [OUTPUT_TEXT_FILE]

    sample_listener.py {--help | -h}

The arguments are:

* The hostname or IP address where the program should listen for
  connections from IPFIX exporters.

* The port on which to listen

* The transport to use, either "tcp" or "udp".

* The optional output file for the textual representation of the
  records.  If not specified, the output is written to the standard
  output.

Unlike sample_listener.py and yaf_mediator_new.py, this program does
not pre-define any templates.

For a similar program that reads records from a file, see
sample_exporter_collector_blind.py.


sample_collector.py
-------------------

A program to read an IPFIX file and write the records as text.

Usage:

    sample_collector.py INPUT_IPFIX_FILE OUTPUT_TEXT_FILE

    sample_collector.py {--help | -h}

The arguments are:

* An IPFIX file from which to read records; use "-" to read from the
  standard input.

* The output file for the textual representation of the records; use
  "-" to write to the standard output.

This program defines a template to use when reading the records, and
that template is similar to the records exported by YAF.  The program
works with non-YAF data, but fields may be 0.

The program does not print the deep packet inspection data produced by
YAF.  For that, use yaf_mediator_new.py or yaf_mediator.py.

For a similar program that reads IPFIX records from a network socket,
see sample_listener.py.


sample_exporter.py
------------------

A program to generate IPFIX records and write them to an IPFIX file.

Usage:

    sample_exporter.py OUTPUT_IPFIX_FILE

    sample_exporter.py {--help | -h}

The program generates IPFIX records using a predefined template and
predefined values for the elements.  The records are exported to the
specified output file or to the standard output if the argument is
"-".

Programs that read the records produced by this program are
sample_exporter_collector.py and sample_exporter_collector_blind.py.


sample_exporter_collector.py
----------------------------

A program to process the IPFIX file created by sample_exporter.py and
write the records to a text file.

Usage:

    sample_exporter_collector.py INPUT_IPFIX_FILE OUTPUT_TEXT_FILE

    sample_exporter_collector.py {--help | -h}

The program reads IPFIX records from the file given as the first
argument and writes the field's values as text to the file named as
the second argument.  An argument of "-" indicates the standard input
or standard output as appropriate.

The program expects the data it reads was written by
sample_exporter.py.  Firstly, it uses internal templates similar to
those used by sample_exporter.py.  In addition, it expects the first
record to be an options record that defines an Information Element
named "weird3byteElement".  While the program works when the first
record is not an options record, it exits with an exception if the
first record is an options record and does not define
"weird3byteElement".

For another program that reads IPFIX data but is not as strict about
what it accepts, see sample_exporter_collector_blind.py.


sample_exporter_collector_blind.py
----------------------------------

A program to read IPFIX records from a file and write the records to a
text file.

Usage:

    sample_exporter_collector.py INPUT_IPFIX_FILE [OUTPUT_TEXT_FILE]

    sample_exporter_collector.py {--help | -h}

The program reads IPFIX records from the file given as the first
argument or from the standard input if the argument is "-".  It writes
the field's values as text to the standard output or to the named
output file.

This program is different than most other sample collection programs
in that it does not predefine any templates prior to reading the data,
and using the templates from the INPUT_IPFIX_FILE as its internal
templates.

For a program similar to this one that listens on the network, see
sample_blind_listener.py.


sample_listener.py
------------------

A program to listen for network connections from an IPFIX exporter and
write the records to a text file.

Usage:

    sample_listener.py ADDRESS PORT TRANSPORT [OUTPUT_TEXT_FILE]

    sample_listener.py {--help | -h}

The arguments are:

* The hostname or IP address where the program should listen for
  connections from IPFIX exporters.

* The port on which to listen

* The transport to use, either "tcp" or "udp".

* The output file for the textual representation of the records.  If
  not specified, the output is written to the standard output.

This program defines a template to use when reading the records, and
that template is similar to the records exported by YAF.  The program
works with non-YAF data, but fields may be 0.

The program does not print the deep packet inspection data produced by
YAF.  For that, use yaf_mediator_new.py.

For a program that listens on the network and does not pre-define any
templates, see sample_blind_listener.py.

The sample_net_exporter.py program may be used to export IPFIX records
on a network socket.

For a similar program that reads IPFIX records from a file, see
sample_collector.py.


sample_mediator.py
------------------

A program to read YAF IPFIX files and export a modified version
(subset) of the records to an IPFIX file.

Usage:

    sample_mediator.py INPUT_IPFIX_FILE OUTPUT_IPFIX_FILE

    sample_mediator.py {--help | -h}

where

* INPUT_IPFIX_FILE is the IPFIX file to read; use "-" to read from the
  standard input.

* OUTPUT_IPFIX_FILE is the IPFIX file to write; use "-" to write to the
  standard output.

This program defines a template to use when reading the records, and
that template is similar to the records exported by YAF.  The program
works with non-YAF data, but fields may be 0.


sample_mpls_collector.py
------------------------

A program to read MPLS information elements from an IPFIX file and
write the records to a text file.

Usage:

    sample_mediator.py INPUT_IPFIX_FILE OUTPUT_TEXT_FILE

    sample_mediator.py {--help | -h}

where

* INPUT_IPFIX_FILE is the IPFIX file to read; use "-" to read from the
  standard input.

* OUTPUT_TEXT_FILE is the file to which a textual representation of
  each record is written.  Use "-" to write to the standard output.

This program is similar to sample_collector.py, except this program
uses a template that includes MPLS-related information elements.

The program does not print the deep packet inspection data produced by
YAF.

For a similar program that reads IPFIX records from a network socket,
see sample_listener.py.


sample_net_exporter.py
----------------------

A program to generate IPFIX records and write them to a socket.

Usage:

    sample_net_exporter.py ADDRESS PORT TRANSPORT

    sample_net_exporter.py {--help | -h}

The arguments are:

* The hostname or IP address the program should connect to for
  exporting the IPFIX records.

* The port to connect to.

* The transport to use, either "tcp" or "udp".

The program generates IPFIX records using a predefined template and
predefined values for the elements.  The records are exported to the
specified ADDRESS and PORT using the given TRANSPORT.

Programs that can listen for these records are sample_listener.py and
sample_blind_listener.py.


shared_utils.py
---------------

A file containing supporting functions used by other sample programs.


time_utils.py
---------------

A file containing supporting functions used by other sample programs.


yaf_mediator.py
---------------

A program to read a YAF IPFIX file and print its content as text to
the standard output.

Usage:

    yaf_mediator.py INPUT_IPFIX_FILE

    yaf_mediator.py {--help | -h}

This program defines a template to use when reading the records, and
that template is similar to the records exported by YAF.  The program
prints values of the deep packet inspection fields it finds the IPFIX
records.

The argument is an IPFIX file or the string "-" to read from the
standard input.  The output is written to the standard output and is a
textual representation of the IPFIX records.

For processing the entries in the subTemplateMultiList that YAF uses
for its deep packet inspection data, the program specifies the records
it expects to find.  Should the format of these records change in a
future version of YAF, the program will raise an exception.

See yaf_mediator_new.py for an improved version of this program.


yaf_mediator_new.py
-------------------

A program to read YAF IPFIX records from a file or the network and write
the records as text to a file or to the standard output.

Usage:

    yaf_mediator_new.py INPUT_IPFIX_FILE [OUTPUT_TEXT_FILE]

    yaf_mediator_new.py ADDRESS [PORT [TRANSPORT [OUTPUT_TEXT_FILE]]]

    yaf_mediator_new.py {--help | -h}

This program defines a template to use when reading the records, and
that template is similar to the records exported by YAF.  The program
prints values of the deep packet inspection fields it finds the IPFIX
records.

If the first argument is the string "-" or names an existing file, the
program reads IPFIX records from the standard input or from that file,
respectively.  The second argument is optional and specifies the
output file for textual representation of the records.  If not
specified, the output is written to the standard output.

Otherwise, the first argument is taken as the hostname or IP address
where the program should listen for connections from IPFIX exporters.
Additional arguments are the port on which to listen (defaults to
18000), the transport to use (either "tcp" (the default) or "udp"),
and the output file for the textual representation of the records.  If
not specified, the output is written to the standard output.

This program is different than yaf_mediator.py in that it does not
define the templates or records before reading.
