/*
** Copyright (C) 2007-2024 by Carnegie Mellon University.
**
** @OPENSOURCE_LICENSE_START@
**
** SiLK 3.22.0
**
** Copyright 2023 Carnegie Mellon University.
**
** NO WARRANTY. THIS CARNEGIE MELLON UNIVERSITY AND SOFTWARE ENGINEERING
** INSTITUTE MATERIAL IS FURNISHED ON AN "AS-IS" BASIS. CARNEGIE MELLON
** UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER EXPRESSED OR IMPLIED,
** AS TO ANY MATTER INCLUDING, BUT NOT LIMITED TO, WARRANTY OF FITNESS FOR
** PURPOSE OR MERCHANTABILITY, EXCLUSIVITY, OR RESULTS OBTAINED FROM USE OF
** THE MATERIAL. CARNEGIE MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF
** ANY KIND WITH RESPECT TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT
** INFRINGEMENT.
**
** Released under a GNU GPL 2.0-style license, please see LICENSE.txt or
** contact permission@sei.cmu.edu for full terms.
**
** [DISTRIBUTION STATEMENT A] This material has been approved for public
** release and unlimited distribution.  Please see Copyright notice for
** non-US Government use and distribution.
**
** GOVERNMENT PURPOSE RIGHTS - Software and Software Documentation
**
** Contract No.: FA8702-15-D-0002
** Contractor Name: Carnegie Mellon University
** Contractor Address: 4500 Fifth Avenue, Pittsburgh, PA 15213
**
** The Government's rights to use, modify, reproduce, release, perform,
** display, or disclose this software are restricted by paragraph (b)(2) of
** the Rights in Noncommercial Computer Software and Noncommercial Computer
** Software Documentation clause contained in the above identified
** contract. No restrictions apply after the expiration date shown
** above. Any reproduction of the software or portions thereof marked with
** this legend must also reproduce the markings.
**
** Carnegie Mellon(R) and CERT(R) are registered in the U.S. Patent and
** Trademark Office by Carnegie Mellon University.
**
** This Software includes and/or makes use of Third-Party Software each
** subject to its own license.
**
** DM23-0973
**
** @OPENSOURCE_LICENSE_END@
*/

/*
**  skipfix.h
**
**    Converts between IPFIX and SiLK Flow Recs
**
*/
#ifndef _SKIPFIX_H
#define _SKIPFIX_H
#ifdef __cplusplus
extern "C" {
#endif

#include <silk/silk.h>

RCSIDENTVAR(rcsID_SKIPFIX_H, "$SiLK: skipfix.h 6c9dfbe0b623 2024-01-17 18:02:34Z mthomas $");

#include <silk/silk_types.h>
#include <silk/libflowsource.h>

/* quiet warnings generated by -Wundef */
#if !SK_HAVE_DECL_FB_ENABLE_SCTP
#define FB_ENABLE_SCTP 0
#endif
#if !SK_HAVE_DECL_HAVE_OPENSSL
#define HAVE_OPENSSL 0
#endif
/* fixbuf not consistent in use of "#if" vs "#ifdef"
 *|#if !SK_HAVE_DECL_HAVE_SPREAD
 *|#define HAVE_SPREAD 0
 *|#endif
 */

SK_DIAGNOSTIC_IGNORE_PUSH("-Wundef")

#include <fixbuf/public.h>

SK_DIAGNOSTIC_IGNORE_POP("-Wundef")

#if !defined(FIXBUF_CHECK_VERSION)
/* must be older than fixbuf 1.8.0.  always return false */
#define FIXBUF_CHECK_VERSION(x,y,z)     0
#elif !defined(FIXBUF_VERSION_MAJOR)
/* fixbuf 1.8.0 defines FIXBUF_CHECK_VERSION() in public.h but does
 * not include the file that defines the variables the macro uses */
#include <fixbuf/version.h>
#endif  /* FIXBUF_CHECK_VERSION */


/**
 * @file
 *
 * SiLK Flow record (rwRec) interface to fixbuf. Supports the reading
 * and writing of IPFIX Files by SiLK applications, and the creation
 * of IPFIX Collecting and Exporting Processes using the SiLK flow
 * format.
 *
 * This file is part of libflowsource.
 *
 * This library supports the creation of fbListener_t and fBuf_t
 * instances configured to read any IPFIX record containing the
 * appropriate information elements as a SiLK rwRec, and the creation
 * of fBuf_t instances configured to write SiLK rwRecs as IPFIX
 * records.
 *
 * To read SiLK Flow records from an IPFIX file, use fopen() to open
 * the file, create a buffer using skiCreateReadBufferForFP(), and
 * iterate over records with skiRwNextRecord().  When done, use
 * fBufFree() to free the resulting buffer and fclose() the file.
 *
 * To write SiLK Flow records to an IPFIX file, fopen() the file,
 * create a buffer using skiCreateWriteBufferForFP(), and write each
 * record with skiRwAppendRecord().  Use fBufFree() to free the
 * resulting buffer and fclose() the file.
 *
 * This library uses the GError facility from glib for reporting
 * errors.  Pass a pointer to a NULL GError * on any call taking an
 * err parameter; if an error occurs, the function will return NULL or
 * FALSE as appropriate, and allocate a GError structure describing
 * the error. If an error occurs, you can use the g_error_matches()
 * macro to match it against FB_ERROR_* constants defined by
 * libfixbuf, and the err->message field to get a human-readable error
 * message. After handling an error, use the g_clear_error() macro to
 * free the error description. See the glib documentation for more
 * details on this facility.
 *
 * See the documentation for libfixbuf for details on the fBuf_t,
 * fbListener_t, fbCollector_t, fbExporter_t, and fbConnSpec_t types,
 * and the fbListenerAppInit_fn and fbListenerAppFree_fn callbacks.
 */

#if !FIXBUF_CHECK_VERSION(2, 99, 0)
#define fbTemplateGetFieldByPosition    fbTemplateGetIndexedIE
#define fbTemplateField_t               fbInfoElement_t
#define fbTemplateFieldGetPEN(_tf)      (_tf)->ent
#define fbTemplateFieldGetId(_tf)       (_tf)->num
#define fbTemplateFieldGetLen(_tf)      (_tf)->len
#define fbTemplateFieldGetName(_tf)     (_tf)->ref.canon->ref.name
#else
#define fbSessionAddTemplate(_a, _b, _c, _d, _e)        \
    fbSessionAddTemplate(_a, _b, _c, _d, NULL, _e)
#endif


/**
 *    The IPFIX Private Enterprise Number for CERT.
 */
#define IPFIX_CERT_PEN  6871



#ifdef __cplusplus
}
#endif
#endif /* _SKIPFIX_H */

/*
** Local Variables:
** mode:c
** indent-tabs-mode:nil
** c-basic-offset:4
** End:
*/
