#! /usr/bin/perl -w
# MD5: bd540a21fba5de29c48631b975debf20
# TEST: ./rwfilter --python-expr='rec.sport==rec.dport' --pass=stdout ../../tests/data.rwf | ../rwcat/rwcat --compression-method=none --byte-order=little --ipv4-output

use strict;
use SiLKTests;

my $rwfilter = check_silk_app('rwfilter');
my $rwcat = check_silk_app('rwcat');
my %file;
$file{data} = get_data_or_exit77('data');
$file{pysilk_plugin} = get_data_or_exit77('pysilk_plugin');
$ENV{PYTHONPATH} = $SiLKTests::testsdir.((defined $ENV{PYTHONPATH}) ? ":$ENV{PYTHONPATH}" : "");
add_plugin_dirs('/src/pysilk');

check_python_plugin($rwfilter);
my $cmd = "$rwfilter --python-expr='rec.sport==rec.dport' --pass=stdout $file{data} | $rwcat --compression-method=none --byte-order=little --ipv4-output";
my $md5 = "bd540a21fba5de29c48631b975debf20";

check_md5_output($md5, $cmd);
