### Below this from SiLK's src/rwflowpack/snippet-rwflowappend_startup.sh

check_dir "INCOMING_DIR"   "${INCOMING_DIR}"
check_dir "ERROR_DIR" "${ERROR_DIR}"
check_dir "DATA_ROOTDIR" "${DATA_ROOTDIR}"

PROG_OPTIONS="${PROG_OPTIONS} --incoming-directory='${INCOMING_DIR}' --error-directory='${ERROR_DIR}' --root-directory='${DATA_ROOTDIR}'"

if [ "x${SITE_CONFIG}" != "x" ] ; then
    if [ -f "${SITE_CONFIG}" ] ; then
        PROG_OPTIONS="${PROG_OPTIONS} --site-config-file='${SITE_CONFIG}'"
    else
        echo "$0: Site file ${SITE_CONFIG} does not exist."
        exit 1
    fi
fi

if [ "x${ARCHIVE_DIR}" != "x" ] ; then
    check_dir "ARCHIVE_DIR" "${ARCHIVE_DIR}"
    PROG_OPTIONS="${PROG_OPTIONS} --archive-directory='${ARCHIVE_DIR}'"
    if [ "x${FLAT_ARCHIVE}" = "x1" ] ; then
        PROG_OPTIONS="${PROG_OPTIONS} --flat-archive"
    fi
fi
if [ "x${POST_COMMAND}" != "x" ]; then
    if [ "x${ARCHIVE_DIR}" = "x" ]; then
        echo "$0: Use of POST_COMMAND requires valid ARCHIVE_DIR"
        exit 1
    fi
    PROG_OPTIONS="${PROG_OPTIONS} --post-command='${POST_COMMAND}'"
fi
if [ "x${HOUR_COMMAND}" != "x" ]; then
    PROG_OPTIONS="${PROG_OPTIONS} --hour-file-command='${HOUR_COMMAND}'"
fi
if [ "x${REJECT_HOURS_PAST}" != "x" ]; then
    PROG_OPTIONS="${PROG_OPTIONS} --reject-hours-past='${REJECT_HOURS_PAST}'"
fi
if [ "x${REJECT_HOURS_FUTURE}" != "x" ]; then
    PROG_OPTIONS="${PROG_OPTIONS} --reject-hours-future='${REJECT_HOURS_FUTURE}'"
fi
if [ "x${APPEND_THREADS}" != "x" ] ; then
    PROG_OPTIONS="${PROG_OPTIONS} --threads=${APPEND_THREADS}"
fi
if [ "x${COMPRESSION_TYPE}" != "x" ] ; then
    PROG_OPTIONS="${PROG_OPTIONS} --compression-method=${COMPRESSION_TYPE}"
fi
if [ "x${POLLING_INTERVAL}" != "x" ] ; then
    PROG_OPTIONS="${PROG_OPTIONS} --polling-interval=${POLLING_INTERVAL}"
fi
