#! /usr/bin/perl -w
# MD5: 78ad36f1b0f393a59e995a7261146e5c
# TEST: ../rwsort/rwsort --fields=dcc ../../tests/data.rwf | ./rwgroup --id-fields=dcc | ../rwcat/rwcat --compression-method=none --byte-order=little --ipv4-output

use strict;
use SiLKTests;

my $rwgroup = check_silk_app('rwgroup');
my $rwcat = check_silk_app('rwcat');
my $rwsort = check_silk_app('rwsort');
my %file;
$file{data} = get_data_or_exit77('data');
$file{fake_cc} = get_data_or_exit77('fake_cc');
$ENV{SILK_COUNTRY_CODES} = "$SiLKTests::PWD/$file{fake_cc}";
my $cmd = "$rwsort --fields=dcc $file{data} | $rwgroup --id-fields=dcc | $rwcat --compression-method=none --byte-order=little --ipv4-output";
my $md5 = "78ad36f1b0f393a59e995a7261146e5c";

check_md5_output($md5, $cmd);
