#! /usr/bin/perl -w
# MD5: 58b4c591c981163445e940ddd23d0603
# TEST: ../rwsort/rwsort --fields=scc ../../tests/data.rwf | ./rwgroup --id-fields=scc | ../rwcat/rwcat --compression-method=none --byte-order=little --ipv4-output

use strict;
use SiLKTests;

my $rwgroup = check_silk_app('rwgroup');
my $rwcat = check_silk_app('rwcat');
my $rwsort = check_silk_app('rwsort');
my %file;
$file{data} = get_data_or_exit77('data');
$file{fake_cc} = get_data_or_exit77('fake_cc');
$ENV{SILK_COUNTRY_CODES} = "$SiLKTests::PWD/$file{fake_cc}";
my $cmd = "$rwsort --fields=scc $file{data} | $rwgroup --id-fields=scc | $rwcat --compression-method=none --byte-order=little --ipv4-output";
my $md5 = "58b4c591c981163445e940ddd23d0603";

check_md5_output($md5, $cmd);
