/*
** Copyright (C) 2007-2025 Carnegie Mellon University
**
** @OPENSOURCE_LICENSE_START@
**
** SiLK 3.24
**
** Copyright 2025 Carnegie Mellon University.
**
** NO WARRANTY. THIS CARNEGIE MELLON UNIVERSITY AND SOFTWARE ENGINEERING
** INSTITUTE MATERIAL IS FURNISHED ON AN "AS-IS" BASIS. CARNEGIE MELLON
** UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER EXPRESSED OR
** IMPLIED, AS TO ANY MATTER INCLUDING, BUT NOT LIMITED TO, WARRANTY OF
** FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY, OR RESULTS
** OBTAINED FROM USE OF THE MATERIAL. CARNEGIE MELLON UNIVERSITY DOES NOT
** MAKE ANY WARRANTY OF ANY KIND WITH RESPECT TO FREEDOM FROM PATENT,
** TRADEMARK, OR COPYRIGHT INFRINGEMENT.
**
** Licensed under a GNU GPL 2.0-style license, please see LICENSE.txt or
** contact permission@sei.cmu.edu for full terms.
**
** [DISTRIBUTION STATEMENT A] This material has been approved for public
** release and unlimited distribution.  Please see Copyright notice for
** non-US Government use and distribution.
**
** This Software includes and/or makes use of Third-Party Software each
** subject to its own license.
**
** DM25-0915
**
** @OPENSOURCE_LICENSE_END@
*/

#include <silk/silk.h>

RCSIDENT("$SiLK: rwipautils.c c7d6bb438741 2025-01-17 20:52:04Z mthomas $");

#include "rwipa.h"


#define IPA_CONFIG_FILE "silk-ipa.conf"
#define IPA_CONFIG_LINE_LENGTH 1024


char *
get_ipa_config(
    void)
{
    skstream_t *conf_stream = NULL;
    char filename[PATH_MAX];
    char line[IPA_CONFIG_LINE_LENGTH];
    char *ipa_url = NULL;
    int rv;

    /* Read in the data file */
    if (NULL == skFindFile(IPA_CONFIG_FILE, filename, sizeof(filename), 1)) {
        skAppPrintErr("Could not locate config file '%s'.",
                      IPA_CONFIG_FILE);
        return NULL;
    }

    /* open input */
    if ((rv = skStreamCreate(&conf_stream, SK_IO_READ, SK_CONTENT_TEXT))
        || (rv = skStreamBind(conf_stream, filename))
        || (rv = skStreamSetCommentStart(conf_stream, "#"))
        || (rv = skStreamOpen(conf_stream)))
    {
        skStreamPrintLastErr(conf_stream, rv, &skAppPrintErr);
        skStreamDestroy(&conf_stream);
        exit(EXIT_FAILURE);
    }
    while (skStreamGetLine(conf_stream, line, sizeof(line), NULL)
           == SKSTREAM_OK)
    {
        /* FIXME: smarter config file reading, please */
        if (strlen(line) > 0) {
            ipa_url = strdup(line);
            break;
        }
    }

    skStreamDestroy(&conf_stream);
    /* Should be free()d by the caller */
    return ipa_url;
}


/*
** Local Variables:
** mode:c
** indent-tabs-mode:nil
** c-basic-offset:4
** End:
*/
