### Below this from SiLK's src/rwpollexec/snippet-rwpollexec_startup.sh

check_empty "COMMAND" "${COMMAND}"
PROG_OPTIONS="${PROG_OPTIONS} --command='${COMMAND}'"

check_empty "INCOMING_DIR" "${INCOMING_DIR}"
check_dir   "INCOMING_DIR" "${INCOMING_DIR}"
PROG_OPTIONS="${PROG_OPTIONS} --incoming-directory='${INCOMING_DIR}'"

check_empty "ERROR_DIR" "${ERROR_DIR}"
check_dir   "ERROR_DIR" "${ERROR_DIR}"
PROG_OPTIONS="${PROG_OPTIONS} --error-directory='${ERROR_DIR}'"

if [ "x${ARCHIVE_DIR}" != "x" ] ; then
    check_dir "ARCHIVE_DIR" "${ARCHIVE_DIR}"
    PROG_OPTIONS="${PROG_OPTIONS} --archive-directory='${ARCHIVE_DIR}'"
    if [ "x${FLAT_ARCHIVE}" = "x1" ] ; then
        PROG_OPTIONS="${PROG_OPTIONS} --flat-archive"
    fi
fi

if [ "x${SIMULTANEOUS}" != "x" ] ; then
    PROG_OPTIONS="${PROG_OPTIONS} --simultaneous=${SIMULTANEOUS}"
fi

if [ "x${POLLING_INTERVAL}" != "x" ] ; then
    PROG_OPTIONS="${PROG_OPTIONS} --polling-interval=${POLLING_INTERVAL}"
fi

if [ "x${TIMEOUT}" != "x" ] ; then
    for val in ${TIMEOUT} ; do
        check=`expr "x${val}" : "x[0-9a-zA-Z][0-9a-zA-Z]*,[0-9][0-9]*$"`
        if [ $check -eq 0 ] ; then
            echo "$0: Not a valid value for TIMEOUT: ${val}"
            exit 1
        fi
        PROG_OPTIONS="${PROG_OPTIONS} --timeout=${val}"
    done
fi
