#! /usr/bin/perl -w
# MD5: multiple
# TEST: ./rwsplit --basename=$temp --flow-limit=10000 ../../tests/data.rwf && ../rwcat/rwcat --compression-method=none --byte-order=little --ipv4-output $temp*

use strict;
use SiLKTests;

my $rwsplit = check_silk_app('rwsplit');
my $rwcat = check_silk_app('rwcat');
my %file;
$file{data} = get_data_or_exit77('data');
my $temp = make_tempname('flow-10k');
my $cmd = "$rwsplit --basename=$temp --flow-limit=10000 $file{data}";

# clean up when we're done
END {
    if (!$ENV{SK_TESTS_SAVEOUTPUT}) {
        # remove files
        unlink glob($temp."*");
    }
}

if (!check_exit_status($cmd)) {
    exit 1;
}

# compute MD5 of each file
for (my $i = 0; my $md5 = <DATA>; ++$i) {
    chomp $md5;
    my $f = sprintf("%s.%08d.rwf", $temp, $i);
    $cmd = "$rwcat --compression-method=none --byte-order=little --ipv4-output $f";
    check_md5_output($md5, $cmd);
}

__DATA__
dda3d4997782a292bbab9d06c11d66c1
b0d85e41e25bbe2446a4e85cd46b3232
d6e97986905049a3051191052b12fd21
76c3183df4467e0c89278842414b538b
b9f58992c3c5aff189866277f0ae52f7
0aae985a7a407ad793e4e094709f7415
9b1c94ab7bb7ef36521b4308155170e6
38c26bbc47b8839f7869903d9452f098
2b358131e20a18618e4262a8fe24e1e6
77ad61d72faf0009baa3de4667e0801a
b984cc0003f777620a093007f4916c87
c4b66fef5cd4d02689607a170af4a908
df05d64b8139f1d0966d3b444a5ba4bb
946c1bdaafc1140aef286a3cf52351f5
2d9516385c5ec9d55b275e7e7971facf
575c3022f13074b9ee3678e33d3f463b
9514f8c47d99adb2d7f4f0f57ecd0112
84e55142afe541089d405bc04021279c
28b4156c1b2878047fc2bfcad4d06c53
5b85ce41bda3dac93fb2196c87f6f4d7
c05538c2380d5afa62643a27d23bd297
66fc5b32c62987e712e33dd655d28fc4
16e21629e90c5f16faa7bf2888e9ad50
d73ee337f4297c50a4a8f50cd5a7d0f3
5d30bf11ba398173ace033e619582b1f
629c6013bf6a5d1b85c0d040120e1427
e20bd1d333a8058194642f93e4968cd1
befe631fedd815f1587a3a878bb8f47e
a43f29ad39a471c8d648b6052add5fb1
4c79d9eb2a279ba1858dfcfadff8c8df
c81ff2f9d7319f9542b0e1c32dc8cf99
ed0aa481cfd735c53cb337d583af07c9
5881a3954ff41826a10d14df63fd2088
c232c1427354c8c3d74ee9f808045341
8521f29074bf7ab5a61745dedd2f28d5
6add288771f304e7ab3b558198b5c21e
d43a6608f9d4036fc5c84fd9fa152f6c
55ec9c3e3905d6d6503753c761d96898
b1773be9a57e148f0ff7f6d190c89f8e
f8eb787ed89235966cd1d33cbf88dce4
128509a632334177ab6db5843d539135
31f7086119980608ea111c5d1063eee1
8bfc261db046dff0811af658ae9ebe40
4b3e5e440b2251d84123545dbbeea0b6
0dedb25007db0f0e0c26457669a5cda0
7c6348ac68abb6acf5f085291fdca821
89074671c71a509b1ee5ebab75b0c04d
ee1bd0d83517aaeb894a916825d8bfb8
b62544d111ad5188bac0b47b42ed94a3
a980513784a75f4c5ae8cacd6a760b0e
4b8023b396ae84a3239230381013bced
