#! /usr/bin/perl -w
# MD5: multiple
# TEST: ./rwsplit --basename=$temp --packet-limit=10000000 ../../tests/data.rwf && ../rwcat/rwcat --compression-method=none --byte-order=little --ipv4-output $temp*

use strict;
use SiLKTests;

my $rwsplit = check_silk_app('rwsplit');
my $rwcat = check_silk_app('rwcat');
my %file;
$file{data} = get_data_or_exit77('data');
my $temp = make_tempname('pkt-10M');
my $cmd = "$rwsplit --basename=$temp --packet-limit=10000000 $file{data}";

# clean up when we're done
END {
    if (!$ENV{SK_TESTS_SAVEOUTPUT}) {
        # remove files
        unlink glob($temp."*");
    }
}

if (!check_exit_status($cmd)) {
    exit 1;
}

# compute MD5 of each file
for (my $i = 0; my $md5 = <DATA>; ++$i) {
    chomp $md5;
    my $f = sprintf("%s.%08d.rwf", $temp, $i);
    $cmd = "$rwcat --compression-method=none --byte-order=little --ipv4-output $f";
    check_md5_output($md5, $cmd);
}

__DATA__
d1bb133837c489ae29cc28148b9ed0cb
aa3a90de24eb8570340d2f05d115741f
de9cdd986589478b6c89853413334711
acd7649b2ee1b187ddf28c58b1e5ac7e
3dd14964a2f5cae7171e8533b385e96f
fbb835d75a481c220a9e11ed612ac823
1966356a4fc0bff8c3721e6e61baa462
64045020d73e729a673609f06832fbca
f834e1c16f92bc0c1d73f112e7e4b13e
322b60bd8be44f5e1afe76e7741f8c55
6cddb1e06a3fbc783108fb829436ee38
86b967ce4d83480a53a6535d1890473b
7bb27cef6776db9c2c66de9eeb284534
8c42c6a28c276399ff0af3154f27f9f7
b6c085905ed22b7bf16a950dfc443115
