### Below this from SiLK's src/sendrcv/snippet-rwsender_startup.sh

check_empty "IDENTIFIER" "${IDENTIFIER}"
PROG_OPTIONS="${PROG_OPTIONS} --identifier=${IDENTIFIER}"

# Add GnuTLS options
if test -n "${TLS_CA}" ; then
    PROG_OPTIONS="${PROG_OPTIONS} --tls-ca='${TLS_CA}'"
    if test -n "${TLS_PKCS12}" ; then
        PROG_OPTIONS="${PROG_OPTIONS} --tls-pkcs12='${TLS_PKCS12}'"
    elif test -z "${TLS_KEY}" || test -z "${TLS_CERT}" ; then
        echo "$0: Setting TLS_CA requires setting either TLS_PKCS12 or both TLS_KEY and TLS_CERT."
        exit 1
    else
        PROG_OPTIONS="${PROG_OPTIONS} --tls-key='${TLS_KEY}' --tls-cert='${TLS_CERT}'"
    fi
    if test -n "${TLS_PRIORITY}" ; then
        PROG_OPTIONS="${PROG_OPTIONS} --tls-priority='${TLS_PRIORITY}'"
    fi
    if test -n "${TLS_SECURITY}" ; then
        PROG_OPTIONS="${PROG_OPTIONS} --tls-security=${TLS_SECURITY}"
    fi
    if test -n "${TLS_CRL}" ; then
        PROG_OPTIONS="${PROG_OPTIONS} --tls-crl='${TLS_CRL}'"
    fi
    if test -n "${TLS_DEBUG_LEVEL}" ; then
        PROG_OPTIONS="${PROG_OPTIONS} --tls-debug-level=${TLS_DEBUG_LEVEL}"
    fi
fi


check_empty "MODE" "${MODE}"
IFS=
case "${MODE}" in
    server)
        check_empty "RECEIVER_CLIENTS" "${RECEIVER_CLIENTS}"
        check_empty "PORT" "${PORT}"
        PROG_OPTIONS="${PROG_OPTIONS} --server-port=${PORT}"
        while read -r LINE ; do
            LINE=`ws_strip ${LINE}`
            CLIENT=`cut_1 ${LINE}`
            FILTER=`cut_2rest ${LINE}`
            PROG_OPTIONS="${PROG_OPTIONS} --client-ident=${CLIENT}"
            if [ "x${FILTER}" != "x" ] ; then
                PROG_OPTIONS="${PROG_OPTIONS} --filter=${CLIENT}:'${FILTER}'"
            fi
        done <<EOF
${RECEIVER_CLIENTS}
EOF
        ;;
    client)
        check_empty "RECEIVER_SERVERS" "${RECEIVER_SERVERS}"
        while read -r LINE ; do
            LINE=`ws_strip ${LINE}`
            SERVER=`cut_1 ${LINE}`
            ADDR=`cut_2 ${LINE}`
            FILTER=`cut_3rest ${LINE}`
            PROG_OPTIONS="${PROG_OPTIONS} --server-address=${SERVER}:${ADDR}"
            if [ "x${FILTER}" != "x" ] ; then
                PROG_OPTIONS="${PROG_OPTIONS} --filter=${SERVER}:'${FILTER}'"
            fi
        done <<EOF
${RECEIVER_SERVERS}
EOF
        ;;
    *)
        echo "$0: Unexpected MODE ${MODE}."
        echo "Set to \"client\" or \"server\"."
        exit 1
        ;;
esac
unset IFS

check_dir "INCOMING_DIR"   "${INCOMING_DIR}"
check_dir "PROCESSING_DIR" "${PROCESSING_DIR}"
check_dir "ERROR_DIR"      "${ERROR_DIR}"

PROG_OPTIONS="${PROG_OPTIONS} --mode=${MODE} --incoming-directory='${INCOMING_DIR}' --processing-directory='${PROCESSING_DIR}' --error-directory='${ERROR_DIR}'"

if [ "x${LOCAL_COPIES}" != "x" ] ; then
    case "${LOCAL_COPIES}" in
        link)
            ;;
        copy)
            PROG_OPTIONS="${PROG_OPTIONS} --unique-local-copies"
            ;;
        *)
            echo "$0: Unexpected LOCAL_COPIES ${LOCAL_COPIES}."
            echo "Set to \"link\" or \"copy\"."
            exit 1
            ;;
    esac
fi

if [ "x${POLLING_INTERVAL}" != "x" ] ; then
    PROG_OPTIONS="${PROG_OPTIONS} --polling-interval=${POLLING_INTERVAL}"
fi


if [ "x${PRIORITIES}" != "x" ] ; then
    IFS=
    while read -r LINE ; do
        LINE=`ws_strip ${LINE}`
        PRIORITY=`cut_1 ${LINE}`
        REGEXP=`cut_2rest ${LINE}`
        PROG_OPTIONS="${PROG_OPTIONS} --priority=${PRIORITY}:'${REGEXP}'"
    done <<EOF
${PRIORITIES}
EOF
    unset IFS
fi


if [ "x${LOCAL_DIRS}" != "x" ] ; then
    check_empty LOCAL_IDENT "${LOCAL_IDENT}"
    IFS=
    count=0
    while read -r LINE ; do
        LINE=`ws_strip ${LINE}`
        DIR=`cut_1 ${LINE}`
        REGEXP=`cut_2rest ${LINE}`
        check_dir LOCAL_DIRS "${DIR}"
        if [ "x${REGEXP}" = "x" ] ; then
            PROG_OPTIONS="${PROG_OPTIONS} --local-directory=:'${DIR}'"
        else
            count=`expr 1 + $count`
            id="${LOCAL_IDENT}$count"
            PROG_OPTIONS="${PROG_OPTIONS} --local-directory=${id}:'${DIR}' --filter=${id}:'${REGEXP}'"
        fi
    done <<EOF
${LOCAL_DIRS}
EOF
    unset IFS
fi

if [ "x${SEND_ATTEMPTS}" != "x" ] ; then
    PROG_OPTIONS="${PROG_OPTIONS} --send-attempts=${SEND_ATTEMPTS}"
fi
