## Copyright (C) 2003-2025 Carnegie Mellon University
##
## @OPENSOURCE_LICENSE_START@
##
## SiLK 3.24
##
## Copyright 2025 Carnegie Mellon University.
##
## NO WARRANTY. THIS CARNEGIE MELLON UNIVERSITY AND SOFTWARE ENGINEERING
## INSTITUTE MATERIAL IS FURNISHED ON AN "AS-IS" BASIS. CARNEGIE MELLON
## UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER EXPRESSED OR
## IMPLIED, AS TO ANY MATTER INCLUDING, BUT NOT LIMITED TO, WARRANTY OF
## FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY, OR RESULTS
## OBTAINED FROM USE OF THE MATERIAL. CARNEGIE MELLON UNIVERSITY DOES NOT
## MAKE ANY WARRANTY OF ANY KIND WITH RESPECT TO FREEDOM FROM PATENT,
## TRADEMARK, OR COPYRIGHT INFRINGEMENT.
##
## Licensed under a GNU GPL 2.0-style license, please see LICENSE.txt or
## contact permission@sei.cmu.edu for full terms.
##
## [DISTRIBUTION STATEMENT A] This material has been approved for public
## release and unlimited distribution.  Please see Copyright notice for
## non-US Government use and distribution.
##
## This Software includes and/or makes use of Third-Party Software each
## subject to its own license.
##
## DM25-0915
##
## @OPENSOURCE_LICENSE_END@
##
## RCSIDENT("$SiLK: build.mk df077b95a142 2025-06-23 12:39:57Z mthomas $")

#  This file contains common rules included into every Makefile.in


########  MANUAL PAGE SUPPORT
#
#  Rules to build (and clean) the manual pages (troff) from the Perl
#  POD (Plain Old Documentation) source files
#
POD2MAN_ARGS = --center="SiLK Tool Suite" --release="$(PACKAGE_STRING)"

pod_edit = $(SED) \
  -e 's|@SILK_DATA_ROOTDIR[@]|$(SILK_DATA_ROOTDIR)|g' \
  -e 's|@prefix[@]|$(prefix)|g'

.pod.man:
	$(AM_V_GEN)$(POD2MAN) $(POD2MAN_ARGS) $< > $@
.pod.1:
	$(AM_V_GEN)$(pod_edit) $< | $(POD2MAN) --section=1 --name="$*" $(POD2MAN_ARGS) > "$@"
.pod.2:
	$(AM_V_GEN)$(pod_edit) $< | $(POD2MAN) --section=2 --name="$*" $(POD2MAN_ARGS) > "$@"
.pod.3:
	$(AM_V_GEN)$(pod_edit) $< | $(POD2MAN) --section=3 --name="$*" $(POD2MAN_ARGS) > "$@"
.pod.5:
	$(AM_V_GEN)$(pod_edit) $< | $(POD2MAN) --section=5 --name="$*" $(POD2MAN_ARGS) > "$@"
.pod.7:
	$(AM_V_GEN)$(pod_edit) $< | $(POD2MAN) --section=7 --name="$*" $(POD2MAN_ARGS) > "$@"
.pod.8:
	$(AM_V_GEN)$(pod_edit) $< | $(POD2MAN) --section=8 --name="$*" $(POD2MAN_ARGS) > "$@"

clean-local: clean-remove-man
clean-remove-man:
	-test -z "$(MANS)" || rm -f $(MANS)



########  DAEMON CONFIGURATION
#
#  The following support the DAEMON.conf, DAEMON.init.d,
#  DAEMON.service, and DAEMON_startup files used for daemon
#  configuration

#  A rule to install the DAEMON.conf files into $(conf_file_dir) and a
#  second rule to uninstall them.  For these rules to work, add the
#  following to the appropriate Makefile.am:
#
#  conf_files = DAEMON1.conf DAEMON2.conf
#  install-data-local: install-conf-files
#  uninstall-local: uninstall-conf-files

#  The install directory is $(prefix)/share/silk/etc/
conf_file_dir = $(pkgdatadir)/etc

install-conf-files: $(conf_files)
	@$(NORMAL_INSTALL)
	$(mkinstalldirs) $(DESTDIR)$(conf_file_dir)
	@list='$(conf_files)'; for p in $$list; do \
	  if test -f "$$p"; then d=; else d="$(srcdir)/"; fi; \
	  f=`echo "$$p" | $(SED) -e 's,^.*/,,;s/\.conf$$//;$(transform);s/$$/\.conf/'`; \
	  echo " $(INSTALL_DATA) '$$d$$p' '$(DESTDIR)$(conf_file_dir)/$$f'"; \
	  $(INSTALL_DATA) "$$d$$p" "$(DESTDIR)$(conf_file_dir)/$$f"; \
	done

uninstall-conf-files:
	@$(NORMAL_UNINSTALL)
	@list='$(conf_files)'; for p in $$list; do \
	  f=`echo "$$p" | $(SED) -e 's,^.*/,,;s/\.conf$$//;$(transform);s/$$/\.conf/'`; \
	  echo " rm -f '$(DESTDIR)$(conf_file_dir)/$$f'"; \
	  rm -f "$(DESTDIR)$(conf_file_dir)/$$f"; \
	done

#  A rule to install the DAEMON.init.d scripts into
#  $(init_d_scripts_dir) and a second rule to uninstall them.  For
#  these rules to work, add the following to the appropriate
#  Makefile.am:
#
#  init_d_scripts = DAEMON1.init.d DAEMON2.init.d
#  install-data-local: install-init-d-scripts
#  uninstall-local: uninstall-init-d-scripts

#  The install directory is $(prefix)/share/silk/etc/init.d/
init_d_scripts_dir = $(pkgdatadir)/etc/init.d

install-init-d-scripts: $(init_d_scripts)
	@$(NORMAL_INSTALL)
	$(mkinstalldirs) $(DESTDIR)$(init_d_scripts_dir)
	@list='$(init_d_scripts)'; for p in $$list; do \
	  if test -f "$$p"; then d=; else d="$(srcdir)/"; fi; \
	  f=`echo "$$p" | $(SED) -e 's,^.*/,,;s,\.init\.d$$,,;$(transform)'`; \
	  echo " $(INSTALL_SCRIPT) '$$d$$p' '$(DESTDIR)$(init_d_scripts_dir)/$$f'"; \
	  $(INSTALL_SCRIPT) "$$d$$p" "$(DESTDIR)$(init_d_scripts_dir)/$$f"; \
	done

uninstall-init-d-scripts:
	@$(NORMAL_UNINSTALL)
	@list='$(init_d_scripts)'; for p in $$list; do \
	  f=`echo "$$p" | $(SED) -e 's,^.*/,,;s,\.init\.d$$,,;$(transform)'`; \
	  echo " rm -f '$(DESTDIR)$(init_d_scripts_dir)/$$f'"; \
	  rm -f "$(DESTDIR)$(init_d_scripts_dir)/$$f"; \
	done

#  A rule to install the DAEMON_startup scripts into
#  $(systemd_scripts_dir) and a second rule to uninstall them.  For
#  these rules to work, add the following to the appropriate
#  Makefile.am:
#
#  systemd_scripts = DAEMON1_startup DAEMON2_startup
#  install-data-local: install-systemd-scripts
#  uninstall-local: uninstall-systemdd-scripts

#  The install directory is $(prefix)/share/silk/libexec/silk/
systemd_scripts_dir = $(pkgdatadir)/libexec/silk

install-systemd-scripts: $(systemd_scripts)
	@$(NORMAL_INSTALL)
	$(mkinstalldirs) $(DESTDIR)$(systemd_scripts_dir)
	@list='$(systemd_scripts)'; for p in $$list; do \
	  if test -f "$$p"; then d=; else d="$(srcdir)/"; fi; \
	  f=`echo "$$p" | $(SED) -e 's,^.*/,,;s/_startup$$//;$(transform);s/$$/_startup/'`; \
	  echo " $(INSTALL_SCRIPT) '$$d$$p' '$(DESTDIR)$(systemd_scripts_dir)/$$f'"; \
	  $(INSTALL_SCRIPT) "$$d$$p" "$(DESTDIR)$(systemd_scripts_dir)/$$f"; \
	done

uninstall-systemd-scripts:
	@$(NORMAL_UNINSTALL)
	@list='$(systemd_scripts)'; for p in $$list; do \
	  f=`echo "$$p" | $(SED) -e 's,^.*/,,;s/_startup$$//;$(transform);s/$$/_startup/'`; \
	  echo " rm -f '$(DESTDIR)$(systemd_scripts_dir)/$$f'"; \
	  rm -f "$(DESTDIR)$(systemd_scripts_dir)/$$f"; \
	done

#  A rule to install the DAEMON.service systemd units into
#  $(systemd_units_dir) and a second rule to uninstall them.  For
#  these rules to work, add the following to the appropriate
#  Makefile.am:
#
#  systemd_units = DAEMON1.service DAEMON2.service
#  install-data-local: install-systemd-units
#  uninstall-local: uninstall-systemd-units

#  The install directory is $(prefix)/share/silk/lib/systemd/system/
systemd_units_dir = $(pkgdatadir)/lib/systemd/system

install-systemd-units: $(systemd_scripts)
	@$(NORMAL_INSTALL)
	$(mkinstalldirs) $(DESTDIR)$(systemd_units_dir)
	@list='$(systemd_units)'; for p in $$list; do \
	  if test -f "$$p"; then d=; else d="$(srcdir)/"; fi; \
	  f="$$( \
		case "$$p" in \
		  (*@.service) at_sign="@" ;; \
		  (*) at_sign="" ;; \
		esac; \
		echo "$$p" | $(SED) -e 's,^.*/,,;s/'$${at_sign}'\.service$$//;$(transform);s/$$/'$${at_sign}'.service/' \
	  )"; \
	  echo " $(INSTALL_SCRIPT) '$$d$$p' '$(DESTDIR)$(systemd_units_dir)/$$f'"; \
	  $(INSTALL_SCRIPT) "$$d$$p" "$(DESTDIR)$(systemd_units_dir)/$$f"; \
	done

uninstall-systemd-units:
	@$(NORMAL_UNINSTALL)
	@list='$(systemd_units)'; for p in $$list; do \
	  f="$$( \
		case "$$p" in \
		  (*@.service) at_sign="@" ;; \
		  (*) at_sign="" ;; \
		esac; \
		echo "$$p" | $(SED) -e 's,^.*/,,;s/'$${at_sign}'\.service$$//;$(transform);s/$$/'$${at_sign}'.service/' \
	  )"; \
	  echo " rm -f '$(DESTDIR)$(systemd_units_dir)/$$f'"; \
	  rm -f "$(DESTDIR)$(systemd_units_dir)/$$f"; \
	done

# Used for dependency purposes and to run the script
GEN_STARTUP_SCRIPT = $(top_builddir)/src/startup/gen-startup-script.sh

# Common snippets used for every service
COMMON_PRELUDE_SNIPPET = $(top_builddir)/src/startup/snippet-common_prelude.sh
INIT_HEADER_SNIPPET = $(top_builddir)/src/startup/snippet-init_header.sh
INIT_FOOTER_SNIPPET = $(top_builddir)/src/startup/snippet-init_footer.sh
SYSTEMD_HEADER_SNIPPET = $(top_builddir)/src/startup/snippet-systemd_header.sh
SYSTEMD_FOOTER_SNIPPET = $(top_builddir)/src/startup/snippet-systemd_footer.sh

# Default set of sh snippets for beginning of init scripts
PRE_INIT_SNIPPETS = \
  $(INIT_HEADER_SNIPPET) \
  $(COMMON_PRELUDE_SNIPPET)

# Default set of sh snippets for end of init scripts
POST_INIT_SNIPPETS = \
  $(INIT_FOOTER_SNIPPET)

# Default set of sh snippets for beginning of systemd startup scripts
PRE_SYSTEMD_SNIPPETS = \
  $(SYSTEMD_HEADER_SNIPPET) \
  $(COMMON_PRELUDE_SNIPPET)

# Default set of sh snippets for end of systemd startup scripts
POST_SYSTEMD_SNIPPETS = \
  $(SYSTEMD_FOOTER_SNIPPET)

#  The following variable converts startup-related files (for example,
#  snippet-NAME.service or sinppet-NAME_startup.sh) to output files by
#  concatenating them together and doing variable substitution. Use it
#  like these examples:
#
#  For NAME.conf: (config file)
#
#  NAME.conf: Makefile $(GEN_STARTUP_FILE_SCRIPT) snippet-NAME.conf
#  	$(GEN_STARTUP_FILE) snippet-NAME.conf
#
#  For NAME.init.d: (init script)
#
#  NAME_INIT_STARTUP_SNIPPETS = \
#      snippet-NAME_header.init.sh \
#      $(PRE_INIT_SNIPPETS) \
#      snippet-NAME_startup.sh.in \
#      $(POST_INIT_SNIPPETS) \
#  NAME.init.d: Makefile $(GEN_STARTUP_FILE_SCRIPT) $(NAME_INIT_SNIPPETS)
#  	$(GEN_STARTUP_FILE) $(NAME_INIT_SNIPPETS)
#
#  Where 'snippet-NAME_header.init.sh' contains structured comments to
#  help sysconfig, and 'snippet-NAME_startup.sh.in' contains checks on
#  configuration specific to this program.
#
#  For NAME.service and NAME@.service: (used for systemd)
#
#  NAME.service NAME@.service : Makefile $(GEN_STARTUP_FILE_SCRIPT) snippet-NAME.service
#   $(GEN_STARTUP_FILE) snippet-NAME.service
#
#  Or for NAME_startup: (used for systemd)
#
#  NAME_SYSTEMD_SNIPPETS = \
#      $(PRE_SYSTEMD_SNIPPETS) \
#      snippet-NAME_startup.sh \
#      $(POST_SYSTEMD_SNIPPETS) \
#  NAME_startup: Makefile $(GEN_STARTUP_FILE_SCRIPT) $(NAME_SYSTEMD_SNIPPETS)
#  	$(GEN_STARTUP_FILE) $(NAME_SYSTEMD_SNIPPETS)
#
#  To ensure the resulting files get built, make sure to add the output
#  file names to the "all-local:" target in the Makefile.am

# Used for dependency purposes and to run the script
GEN_STARTUP_FILE_SCRIPT = $(top_srcdir)/src/startup/gen-startup-file.sh

GEN_STARTUP_FILE = $(AM_V_GEN) \
  SED="$(SED)" \
  SILK_DATA_ROOTDIR="$(SILK_DATA_ROOTDIR)" \
  libdir="$(libdir)" \
  libexecdir="$(libexecdir)" \
  localstatedir="$(localstatedir)" \
  prefix="$(prefix)" \
  sbindir="$(sbindir)" \
  srcdir="$(srcdir)" \
  sysconfdir="$(sysconfdir)" \
  transform="$(transform)" \
  $(GEN_STARTUP_FILE_SCRIPT) $@

########  TESTING (MAKE CHECK) SUPPORT
#
#  Rules to build files in the top-level "tests" directory that may be
#  required during testing.  To actually build these files, add the
#  appropriate $(SILK_TESTFOO) variable(s) to check_DATA
#
SILK_TESTBAGS = $(top_builddir)/tests/made-bag-files
$(SILK_TESTBAGS):
	cd $(top_builddir)/tests && $(MAKE) made-bag-files

SILK_TESTDATA = $(top_builddir)/tests/made-test-data
$(SILK_TESTDATA):
	cd $(top_builddir)/tests && $(MAKE) check

SILK_TESTPDU = $(top_builddir)/tests/small.pdu
$(SILK_TESTPDU):
	cd $(top_builddir)/tests && $(MAKE) small.pdu

SILK_TESTPMAPS = $(top_builddir)/tests/made-pmap-files
$(SILK_TESTPMAPS):
	cd $(top_builddir)/tests && $(MAKE) made-pmap-files

SILK_TESTSCAN =	$(top_builddir)/tests/scandata.rwf
$(SILK_TESTSCAN):
	cd $(top_builddir)/tests && $(MAKE) scandata.rwf

SILK_SENDRCVDATA = $(top_builddir)/tests/made-sendrcv-data
$(SILK_SENDRCVDATA):
	cd $(top_builddir)/tests && $(MAKE) made-sendrcv-data

SILK_TESTSETS = $(top_builddir)/tests/made-set-files
$(SILK_TESTSETS):
	cd $(top_builddir)/tests && $(MAKE) made-set-files

SILK_TESTSIPS004 = $(top_builddir)/tests/sips-004-008.rw
$(SILK_TESTSIPS004):
	cd $(top_builddir)/tests && $(MAKE) sips-004-008.rw

# Ensure the local 'tests' sub-directory exists
SILK_TESTSDIR = ./tests/touch-dir
$(SILK_TESTSDIR):
	test -d ./tests || mkdir ./tests
	touch $@

# Set defaults to use for the testing harness used by "make check"
#
AM_TESTS_ENVIRONMENT = \
  srcdir=$(srcdir) ; export srcdir ; \
  top_srcdir=$(top_srcdir) ; export top_srcdir ; \
  top_builddir=$(top_builddir) ; export top_builddir ;
PL_LOG_COMPILER = $(PERL)
AM_PL_LOG_FLAGS = -I$(top_srcdir)/tests -w

LOG_COMPILER = $(PL_LOG_COMPILER)
AM_LOG_FLAGS = $(AM_PL_LOG_FLAGS)

clean-local: clean-remove-tests-touch-dir
clean-remove-tests-touch-dir:
	-rm -f $(SILK_TESTSDIR)

# A rule to rebuild all the automatically generated tests
# This will rebuild all the test files in tests/
sk-make-silktests: all $(check_PROGRAMS) $(check_DATA) $(srcdir)/tests/make-tests.pl
	$(AM_TESTS_ENVIRONMENT) $(LOG_COMPILER) $(AM_LOG_FLAGS) $(srcdir)/tests/make-tests.pl



.PHONY: clean-remove-man clean-remove-tests-touch-dir \
	install-conf-files uninstall-conf-files \
	install-init-d-scripts uninstall-init-d-scripts \
	install-systemd-scripts uninstall-systemd-scripts \
	install-systemd-units uninstall-systemd-units \
	sk-make-silktests
