### Below this from SiLK's src/rwflowpack/snippet-rwflowpack_startup.sh

check_empty "INPUT_MODE" "${INPUT_MODE}"
case "${INPUT_MODE}" in
    stream)
        check_empty "SENSOR_CONFIG" "${SENSOR_CONFIG}"
        PROG_OPTIONS="${PROG_OPTIONS} --sensor-configuration='${SENSOR_CONFIG}'"
        ;;
    fcfiles)
        check_empty "SENSOR_CONFIG" "${SENSOR_CONFIG}"
        PROG_OPTIONS="${PROG_OPTIONS} --input-mode=fcfiles"
        PROG_OPTIONS="${PROG_OPTIONS} --sensor-configuration='${SENSOR_CONFIG}'"
        ;;
    respool)
        PROG_OPTIONS="${PROG_OPTIONS} --input-mode=respool"
        ;;
    *)
        echo "$0: Unexpected INPUT_MODE ${INPUT_MODE}."
        echo "Set to \"stream\", \"fcfiles\", or \"respool\"."
        exit 1
        ;;
esac


if [ "x${COMPRESSION_TYPE}" != "x" ] ; then
    PROG_OPTIONS="${PROG_OPTIONS} --compression-method=${COMPRESSION_TYPE}"
fi
if [ "x${FILE_LOCKING}" = "x0" ] ; then
    PROG_OPTIONS="${PROG_OPTIONS} --no-file-locking"
fi
if [ "x${PACK_INTERFACES}" = "x1" ] ; then
    PROG_OPTIONS="${PROG_OPTIONS} --pack-interfaces"
fi
if [ "x${FLUSH_TIMEOUT}" != "x" ] ; then
    PROG_OPTIONS="${PROG_OPTIONS} --flush-timeout=${FLUSH_TIMEOUT}"
fi
if [ "x${FILE_CACHE_SIZE}" != "x" ] ; then
    PROG_OPTIONS="${PROG_OPTIONS} --file-cache-size=${FILE_CACHE_SIZE}"
fi
if [ "x${POLLING_INTERVAL}" != "x" ] ; then
    PROG_OPTIONS="${PROG_OPTIONS} --polling-interval=${POLLING_INTERVAL}"
fi
if [ "x${SITE_CONFIG}" != "x" ] ; then
    PROG_OPTIONS="${PROG_OPTIONS} --site-config-file='${SITE_CONFIG}'"
fi

if [ "x${PACKING_LOGIC}" != "x" ] ; then
    case "${INPUT_MODE}" in
        respool)
            ;;
        *)
            PROG_OPTIONS="${PROG_OPTIONS} --packing-logic='${PACKING_LOGIC}'"
            ;;
    esac
fi

if [ "x${ARCHIVE_DIR}" != "x" ] ; then
    check_dir "ARCHIVE_DIR" "${ARCHIVE_DIR}"
    PROG_OPTIONS="${PROG_OPTIONS} --archive-directory='${ARCHIVE_DIR}'"
    if [ "x${FLAT_ARCHIVE}" = "x1" ] ; then
        PROG_OPTIONS="${PROG_OPTIONS} --flat-archive"
    fi
fi
if [ "x${POST_ARCHIVE_COMMAND}" != "x" ] ; then
    if [ "x${ARCHIVE_DIR}" = "x" ]; then
        echo "$0: Use of POST_ARCHIVE_COMMAND requires valid ARCHIVE_DIR"
        exit 1
    fi
    PROG_OPTIONS="${PROG_OPTIONS} --post-archive-command='${POST_ARCHIVE_COMMAND}'"
fi
if [ "x${ERROR_DIR}" != "x" ] ; then
    check_dir "ERROR_DIR" "${ERROR_DIR}"
    PROG_OPTIONS="${PROG_OPTIONS} --error-directory='${ERROR_DIR}'"
fi

case "${INPUT_MODE}" in
    fcfiles|respool)
        check_dir "INCOMING_DIR" "${INCOMING_DIR}"
        PROG_OPTIONS="${PROG_OPTIONS} --incoming-directory='${INCOMING_DIR}'"
        ;;
    *)
        ;;
esac


check_empty "OUTPUT_MODE" "${OUTPUT_MODE}"
case "${OUTPUT_MODE}" in
    local-storage|local)
        check_dir "DATA_ROOTDIR" "${DATA_ROOTDIR}"
        PROG_OPTIONS="${PROG_OPTIONS} --output-mode=local-storage --root-directory='${DATA_ROOTDIR}'"
        ;;
    incremental-files)
        check_dir "INCREMENTAL_DIR" "${INCREMENTAL_DIR}"
        PROG_OPTIONS="${PROG_OPTIONS} --output-mode=incremental-files --incremental-directory='${INCREMENTAL_DIR}'"
        ;;
    remote|sending)
        check_dir "SENDER_DIR" "${SENDER_DIR}"
        check_dir "INCREMENTAL_DIR" "${INCREMENTAL_DIR}"
        PROG_OPTIONS="${PROG_OPTIONS} --output-mode=sending --sender-directory='${SENDER_DIR}' --incremental-directory='${INCREMENTAL_DIR}'"
        ;;
    *)
        echo "$0: Unexpected OUTPUT_MODE ${OUTPUT_MODE}."
        echo "Set to \"local-storage\" or \"incremental-files\"."
        exit 1
        ;;
esac

# Be certain EXTRA_ENVVAR ends with a space when it is non-empty
if [ "x${EXTRA_ENVVAR}" != "x" ]; then
    if [ "x${SILK_IPFIX_PRINT_TEMPLATES}" != "x" ]; then
        EXTRA_ENVVAR="${EXTRA_ENVVAR} SILK_IPFIX_PRINT_TEMPLATES=${SILK_IPFIX_PRINT_TEMPLATES} "
    else
        EXTRA_ENVVAR="${EXTRA_ENVVAR} "
    fi
elif [ "x${SILK_IPFIX_PRINT_TEMPLATES}" != "x" ]; then
    EXTRA_ENVVAR="SILK_IPFIX_PRINT_TEMPLATES=${SILK_IPFIX_PRINT_TEMPLATES} "
fi
