#! /usr/bin/perl -w
# MD5: 02ed7ee9acb653c9a7256f5b1a306337
# TEST: ../rwsort/rwsort --python-file=../../tests/pysilk-plugin.py --fields=lower_port ../../tests/data.rwf | ./rwgroup --python-file=../../tests/pysilk-plugin.py --id-fields=lower_port | ../rwcat/rwcat --compression-method=none --byte-order=little --ipv4-output

use strict;
use SiLKTests;

my $rwgroup = check_silk_app('rwgroup');
my $rwcat = check_silk_app('rwcat');
my $rwsort = check_silk_app('rwsort');
my %file;
$file{data} = get_data_or_exit77('data');
$file{pysilk_plugin} = get_data_or_exit77('pysilk_plugin');
$ENV{PYTHONPATH} = $SiLKTests::testsdir.((defined $ENV{PYTHONPATH}) ? ":$ENV{PYTHONPATH}" : "");
add_plugin_dirs('/src/pysilk');

check_python_plugin($rwgroup);
my $cmd = "$rwsort --python-file=$file{pysilk_plugin} --fields=lower_port $file{data} | $rwgroup --python-file=$file{pysilk_plugin} --id-fields=lower_port | $rwcat --compression-method=none --byte-order=little --ipv4-output";
my $md5 = "02ed7ee9acb653c9a7256f5b1a306337";

check_md5_output($md5, $cmd);
