#! /usr/bin/perl -w
# MD5: 6ceb0c4f07431cfc2ab3334796b441a4
# TEST: ./rwnetmask --6dip-prefix=64 --6sip-prefix=120 ../../tests/data-v6.rwf | ../rwcat/rwcat --compression-method=none --byte-order=little --milliseconds

use strict;
use SiLKTests;

my $rwnetmask = check_silk_app('rwnetmask');
my $rwcat = check_silk_app('rwcat');
my %file;
$file{v6data} = get_data_or_exit77('v6data');
check_features(qw(ipv6));
my $cmd = "$rwnetmask --6dip-prefix=64 --6sip-prefix=120 $file{v6data} | $rwcat --compression-method=none --byte-order=little --milliseconds";
my $md5 = "6ceb0c4f07431cfc2ab3334796b441a4";

check_md5_output($md5, $cmd);
