#! /usr/bin/perl -w
# MD5: multiple
# TEST: ./rwsplit --basename=$temp --byte-limit=10000000 --seed=737292 --sample-ratio=1000 ../../tests/data.rwf && ../rwcat/rwcat --compression-method=none --byte-order=little --ipv4-output $temp*

use strict;
use SiLKTests;

my $rwsplit = check_silk_app('rwsplit');
my $rwcat = check_silk_app('rwcat');
my %file;
$file{data} = get_data_or_exit77('data');
my $temp = make_tempname('byte-10M-sample');
my $cmd = "$rwsplit --basename=$temp --byte-limit=10000000 --seed=737292 --sample-ratio=1000 $file{data}";

# clean up when we're done
END {
    if (!$ENV{SK_TESTS_SAVEOUTPUT}) {
        # remove files
        unlink glob($temp."*");
    }
}

if (!check_exit_status($cmd)) {
    exit 1;
}

# compute MD5 of each file
for (my $i = 0; my $md5 = <DATA>; ++$i) {
    chomp $md5;
    my $f = sprintf("%s.%08d.rwf", $temp, $i);
    $cmd = "$rwcat --compression-method=none --byte-order=little --ipv4-output $f";
    check_md5_output($md5, $cmd);
}

__DATA__
55cbd185aee2094b566a5aa342a63372
16198e1e6ec2842dee2802a49c2b3f52
a2022585ab11f9956b78bf3054bf6e39
02b7a6557cbc7cffee45a775420e0231
01ff865e9aa9e454cf17c682d0240865
e3c9fac4843ba05e81f81654a5e0aa21
ca31e2b0e13ba742f60c5f7db7b42f68
9fdee91732d455cce6c2e812eef37852
0a2746f747ec04f807e8d10b2adb7183
002626d39719e2ca290257ea1b88e77d
e8f0c2b4f81f4bfe161e6b5d2622783f
f97c722981967548094e0031c44d36c4
705dcf5413c4db4dc925b0b81defea9b
