#! /usr/bin/perl -w
# MD5: multiple
# TEST: ./rwsplit --basename=$temp --ip-limit=5000 ../../tests/data.rwf && ../rwcat/rwcat --compression-method=none --byte-order=little --ipv4-output $temp*

use strict;
use SiLKTests;

my $rwsplit = check_silk_app('rwsplit');
my $rwcat = check_silk_app('rwcat');
my %file;
$file{data} = get_data_or_exit77('data');
my $temp = make_tempname('ip-5k');
my $cmd = "$rwsplit --basename=$temp --ip-limit=5000 $file{data}";

# clean up when we're done
END {
    if (!$ENV{SK_TESTS_SAVEOUTPUT}) {
        # remove files
        unlink glob($temp."*");
    }
}

if (!check_exit_status($cmd)) {
    exit 1;
}

# compute MD5 of each file
for (my $i = 0; my $md5 = <DATA>; ++$i) {
    chomp $md5;
    my $f = sprintf("%s.%08d.rwf", $temp, $i);
    $cmd = "$rwcat --compression-method=none --byte-order=little --ipv4-output $f";
    check_md5_output($md5, $cmd);
}

__DATA__
b9903eb3d50207549a0b14ff750f2e5a
8a98da10d75af9c501be164b41fe20bb
26e54298679c7af2a67756de557ae39d
5004fb4947e4973b7950f6921deb6daa
545a8801d15fddc95ace5de9b7cc7b40
6caab45fe5ced561524bdde6ae4d63b9
980dbd88fa7eb594eb764fe9ac594b9c
4127b3b79c9b1b8a16650e27838c9d21
3b01e5793a11f0a1c75bbe4012e19930
4a6b690d81e84bc3858b809ad8b6ecc2
2182b63f8f302bfd21ee005b8142488a
d3b8c331a8f736110a9d46004236e4d8
55ed3ab4f41f3672fde2cf95e126c161
a7f0c0b80ccc2c9aa16973071ca30074
cf9dde6dc70d632d3970c76ac209882d
124f18a1a7f8fc25e1ec98a0478adc67
77da313c769291ae8098832de98585b3
6c36d7c265942ff4b8488278fb2292ad
30413c71c0e8c0f3e396382b21322bad
f0852cd4e93cc1d8cd2ed53fb20271f4
3293333312a62496b629c0aa1e072fc9
b239636dfbd8620107ed80c700b051c1
2eecf74f76c976ff54f761c89eb3ec1c
fa7cc0fe1aefd0d247aebd38cab6a5ca
169433788361c033489823f6035abda0
6891c2055c6a3081d651d1df8ad87828
879e49be4de8247f0c42f0c6441c80af
d8715a9ab6a34c625c33388a49a93a31
b545a24f05c1a4a3c6d6129c1a0ff315
efeead5704e732d1273d23215ad774c2
7243333bb03f86d117c2d368cb89b05d
74036bf08c2b7a8bf8a30c63a966839b
da684d3eb451f667da83d22b63c79540
5e5f00ed5914b0a43ea6ec1a9b9d2dae
db68038a204fa83e5cbb21be06338acf
a407759012452a56631c77308f852c54
0c8ccc28d1b8bb9a251748583078837c
ee881b724af99c0b8e265df7fe52a270
40554270e0f7d72f5bf52ee893ddb449
0ca8f9a1fa935fb03b001e692330d535
da950fc2b800aff5a32db0290fabf16e
115a478a5289952c750e5d7b973e4d4d
e11de4e474c58e99d4279cb47a25f5a4
b8851396fb6c56b19fe0dfb90db18835
27ddac22c703f81fa10bd2cbd3002377
5768a1b8b0691dc2d5f6b93e3ce1ca1f
62c7b6b79258a2ffdebd8a47ed92bcec
1928577ea8e65748ef5c49c3bf808247
de23415759ca45205db77c5033d05951
c03f639576633d31eda552648844a2f6
18f2e7272dba07b4c8cf67c034cec391
4d047a11efa79242a802e777c9972a9e
1b41f1dfef1520f39e503cc2c0041c74
12fe735480a51f0b5da9e1a1fdbc1748
ea9cbb76f96ade66fa0e6d3fb0a45a10
92212a505d45d529ffc5685015c84fb2
27d592d450d3c4dff565c23cffb39045
ae96711c27df3f26f64593cb4a425b11
8ee3cd2bd32bd0f7598ee19f5a543e84
1313cd06f881a7edb8662f07cf7b638a
a26553ada6d12fc33739b16b12095a94
abedb090169dd4e655e19b63a8ae8b70
6e95b8676ac35061e067719e83b85a6d
