### Below this from SiLK's src/sendrcv/snippet-rwreceiver_startup.sh

check_empty "IDENTIFIER" "${IDENTIFIER}"
PROG_OPTIONS="${PROG_OPTIONS} --identifier=${IDENTIFIER}"

# Add GnuTLS options
if test -n "${TLS_CA}" ; then
    PROG_OPTIONS="${PROG_OPTIONS} --tls-ca='${TLS_CA}'"
    if test -n "${TLS_PKCS12}" ; then
        PROG_OPTIONS="${PROG_OPTIONS} --tls-pkcs12='${TLS_PKCS12}'"
    elif test -z "${TLS_KEY}" || test -z "${TLS_CERT}" ; then
        echo "$0: Setting TLS_CA requires setting either TLS_PKCS12 or both TLS_KEY and TLS_CERT."
        exit 1
    else
        PROG_OPTIONS="${PROG_OPTIONS} --tls-key='${TLS_KEY}' --tls-cert='${TLS_CERT}'"
    fi
    if test -n "${TLS_PRIORITY}" ; then
        PROG_OPTIONS="${PROG_OPTIONS} --tls-priority='${TLS_PRIORITY}'"
    fi
    if test -n "${TLS_SECURITY}" ; then
        PROG_OPTIONS="${PROG_OPTIONS} --tls-security=${TLS_SECURITY}"
    fi
    if test -n "${TLS_CRL}" ; then
        PROG_OPTIONS="${PROG_OPTIONS} --tls-crl='${TLS_CRL}'"
    fi
    if test -n "${TLS_DEBUG_LEVEL}" ; then
        PROG_OPTIONS="${PROG_OPTIONS} --tls-debug-level=${TLS_DEBUG_LEVEL}"
    fi
fi


check_empty "MODE" "${MODE}"
IFS=
case "${MODE}" in
    server)
        check_empty "SENDER_CLIENTS" "${SENDER_CLIENTS}"
        check_empty "PORT" "${PORT}"
        PROG_OPTIONS="${PROG_OPTIONS} --server-port=${PORT}"
        while read -r LINE ; do
            LINE=`ws_strip ${LINE}`
            CLIENT=`cut_1 ${LINE}`
            PROG_OPTIONS="${PROG_OPTIONS} --client-ident=${CLIENT}"
        done <<EOF
${SENDER_CLIENTS}
EOF
        ;;
    client)
        check_empty "SENDER_SERVERS" "${SENDER_SERVERS}"
        while read -r LINE ; do
            LINE=`ws_strip ${LINE}`
            SERVER=`cut_1 ${LINE}`
            ADDR=`cut_2 ${LINE}`
            PROG_OPTIONS="${PROG_OPTIONS} --server-address=${SERVER}:${ADDR}"
        done <<EOF
${SENDER_SERVERS}
EOF
        ;;
    *)
        echo "$0: Unexpected MODE ${MODE}."
        echo "Set to \"client\" or \"server\"."
        exit 1
        ;;
esac
unset IFS

check_dir "DESTINATION_DIR" "${DESTINATION_DIR}"

PROG_OPTIONS="${PROG_OPTIONS} --mode=${MODE} --destination-directory='${DESTINATION_DIR}'"


case "${DUPLICATE_COPIES}" in
    "")
        DUPLICATE_COPIES=no
        ;;
    no)
        ;;
    link)
        ;;
    copy)
        PROG_OPTIONS="${PROG_OPTIONS} --unique-duplicates"
        ;;
    *)
        echo "$0: Unexpected DUPLICATE_COPIES ${DUPLICATE_COPIES}."
        echo "Set to \"no\", \"link\", or \"copy\"."
        exit 1
        ;;
esac


if [ "x${DUPLICATE_DIRS}" != "x" -a  "x${DUPLICATE_COPIES}" != "xno" ] ; then
    IFS=
    while read -r LINE ; do
        LINE=`ws_strip ${LINE}`
        check_dir DUPLICATE_DIRS "${LINE}"
        PROG_OPTIONS="${PROG_OPTIONS} --duplicate-destination='${LINE}'"
    done <<EOF
${DUPLICATE_DIRS}
EOF
    unset IFS
fi

if test -n "${POST_COMMAND}" ; then
    PROG_OPTIONS="${PROG_OPTIONS} --post-command='${POST_COMMAND}'"
fi

if test -n "${FREESPACE_MINIMUM}" ; then
    PROG_OPTIONS="${PROG_OPTIONS} --freespace-minimum='${FREESPACE_MINIMUM}'"
fi

if test -n "${SPACE_MAXIMUM_PERCENT}" ; then
    PROG_OPTIONS="${PROG_OPTIONS} --space-maximum-percent='${SPACE_MAXIMUM_PERCENT}'"
fi
