
### Below this from SiLK's src/startup/snippet-init_footer.sh
### Init startup script footer: Final checks and handling arguments

check_dir   "PID_DIR"  "${PID_DIR}"

PIDFILE="${PID_DIR}/${PROGRAM_NAME}${INIT_SCRIPT_SUFFIX}.pid"
PROG_OPTIONS="${PROG_OPTIONS} --pidfile='${PIDFILE}' --log-level=${LOG_LEVEL}"

LOG_BASENAME="${PROGRAM_NAME}${INIT_SCRIPT_SUFFIX}"
case "${LOG_TYPE}" in
    syslog)
        PROG_OPTIONS="${PROG_OPTIONS} --log-destination=syslog"
        ;;
    legacy)
        check_dir "LOG_DIR" "${LOG_DIR}"
        PROG_OPTIONS="${PROG_OPTIONS} --log-directory='${LOG_DIR}' --log-basename='${LOG_BASENAME}'"
        ;;
    *)
        echo "$0: Unexpected LOG_TYPE ${LOG_TYPE}."
        echo "Set to \"legacy\" or \"syslog\"."
        exit 1
        ;;
esac


#######################################################################

# Check if $pid is running
checkpid() {
    kill -0 $1 >/dev/null 2>&1 && return 0
    return 1
}


# Get the process id from the PID file
getPid() {
    RETVAL=1
    if [ -f "${PIDFILE}" ] ; then
        RETVAL=2
        read pid < "${PIDFILE}"
        if [ "X$pid" != "X" ] ; then
            RETVAL=3
            # Found a pid
            if checkpid $pid ; then
                echo $pid
                RETVAL=0
            fi
        fi
    fi
    echo ""
    return $RETVAL
}


status() {
    if [ $# -gt 0 ] ; then
        doEcho=0
    else
        doEcho=1
    fi

    # first check if the process is running
    pid=`getPid`
    RETVAL=$?

    if [ $doEcho -eq 1 ] ; then
        case "$RETVAL" in
          0)
            echo "${PROGRAM_NAME}${INIT_SCRIPT_SUFFIX} is running with pid $pid"
            ;;
          1)
            echo "${PROGRAM_NAME}${INIT_SCRIPT_SUFFIX} is stopped"
            ;;
          *)
            echo "${PROGRAM_NAME}${INIT_SCRIPT_SUFFIX} is dead but pid file exists"
            ;;
        esac
    fi
    return $RETVAL
}


start() {
    (status 'silent')
    pStat=$?
    if [ $pStat -eq 0 ] ; then
        status
        return 0
    fi

    /bin/echo -n "Starting ${PROGRAM_NAME}${INIT_SCRIPT_SUFFIX}:	"
    /bin/rm -f ${PIDFILE} 2> /dev/null

    if [ X`whoami` = "X${USER}" ] ; then
        eval "${EXTRA_ENVVAR}${PROGRAM_PATH} ${PROG_OPTIONS} ${EXTRA_OPTIONS} &"
    else
        su - ${USER} -c "${EXTRA_ENVVAR}${PROGRAM_PATH} ${PROG_OPTIONS} ${EXTRA_OPTIONS} &"
    fi
    RETVAL=$?
    if [ "$RETVAL" -ne "0" ] ; then
        echo "[Failed]"
    else
        sleep 1
        PID=`getPid`
        if [ "x$PID" = "x" ] ; then
            echo "[Failed]"
            RETVAL=1
        else
            echo '[OK]'
        fi
    fi
    return $RETVAL
}


stop() {
    Pid=`getPid`
    if [ "X${Pid}" = "X" ] ; then
        echo "${PROGRAM_NAME}${INIT_SCRIPT_SUFFIX} not running"
        return 1
    fi
    /bin/echo -n "Stopping ${PROGRAM_NAME}${INIT_SCRIPT_SUFFIX}:	"
    /bin/kill -s TERM $Pid
    for s in 2 3 4 6 7; do
        sleep $s
        if checkpid $Pid ; then
            :
        else
            break;
        fi
    done
    if checkpid $Pid ; then
        # Kill the entire process group
        /bin/kill -s KILL "-$Pid"
        sleep 1
    fi
    (checkpid $Pid)
    RETVAL=$?
    [ "$RETVAL" -eq "1" ] && echo '[OK]' || echo '[FAILED]'
    /bin/rm -f ${PIDFILE} 2> /dev/null
    return $RETVAL
}


restart(){
    (stop)
    (start)
}


case "$1" in
  start)
    (start)
    RETVAL=$?
    ;;

  stop)
    (stop)
    RETVAL=$?
    ;;

  restart)
    (restart)
    RETVAL=$?
    ;;

  force-reload)
    (restart)
    RETVAL=$?
    ;;

  status)
    (status)
    RETVAL=$?
    ;;

  *)
    echo "Usage: $0 {start|stop|status|restart|force-reload}"
    RETVAL=1
    ;;
esac

exit $RETVAL


#######################################################################
# @OPENSOURCE_LICENSE_START@
#
# SiLK 3.24
#
# Copyright 2025 Carnegie Mellon University.
#
# NO WARRANTY. THIS CARNEGIE MELLON UNIVERSITY AND SOFTWARE ENGINEERING
# INSTITUTE MATERIAL IS FURNISHED ON AN "AS-IS" BASIS. CARNEGIE MELLON
# UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER EXPRESSED OR
# IMPLIED, AS TO ANY MATTER INCLUDING, BUT NOT LIMITED TO, WARRANTY OF
# FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY, OR RESULTS
# OBTAINED FROM USE OF THE MATERIAL. CARNEGIE MELLON UNIVERSITY DOES NOT
# MAKE ANY WARRANTY OF ANY KIND WITH RESPECT TO FREEDOM FROM PATENT,
# TRADEMARK, OR COPYRIGHT INFRINGEMENT.
#
# Licensed under a GNU GPL 2.0-style license, please see LICENSE.txt or
# contact permission@sei.cmu.edu for full terms.
#
# [DISTRIBUTION STATEMENT A] This material has been approved for public
# release and unlimited distribution.  Please see Copyright notice for
# non-US Government use and distribution.
#
# This Software includes and/or makes use of Third-Party Software each
# subject to its own license.
#
# DM25-0915
#
# @OPENSOURCE_LICENSE_END@
#######################################################################
