### Below this from SiLK's src/startup/snippet-init_header.sh

PROGRAM_NAME="@program_name@"

# Extract an addendum from the filename. For example, an init script
# named '@program_name@-secondary' would look for a config file named
# '@program_name@'-secondary.conf  and produce log and pid files with
# '-secondary' in their names.

SCRIPT_BASE_NAME="$( basename -- "$0" | sed -e 's/\.init\.d$//' -e 's/\.sh$//' )"
INIT_SCRIPT_SUFFIX="$(
    echo "$SCRIPT_BASE_NAME" |
    sed -ne "/^${PROGRAM_NAME}-/ s/^${PROGRAM_NAME}// p"
)"

# The INIT_SCRIPT_SUFFIX is used as part of the filename of the config
# file, as well as the PID file and log file base name.

SCRIPT_CONFIG_FILENAME="${PROGRAM_NAME}${INIT_SCRIPT_SUFFIX}.conf"
