
### Below this from SiLK's src/startup/snippet-systemd_footer.sh
### systemd startup script footer: Final checks and execution.

# Always set the log level
PROG_OPTIONS="${PROG_OPTIONS} --log-level=${LOG_LEVEL}"

# And for systemd services, don't daemonize
PROG_OPTIONS="${PROG_OPTIONS} --no-daemon"

LOG_BASENAME="${PROGRAM_NAME}${SYSTEMD_INSTANCE_SUFFIX}"
case "${LOG_TYPE}" in
    syslog)
        PROG_OPTIONS="${PROG_OPTIONS} --log-destination=syslog"
        ;;
    legacy)
        check_dir "LOG_DIR" "${LOG_DIR}"
        PROG_OPTIONS="${PROG_OPTIONS} --log-directory=${LOG_DIR} --log-basename=${LOG_BASENAME}"
        ;;
    *)
        echo "$0: Unexpected LOG_TYPE ${LOG_TYPE}."
        echo "Set to \"legacy\" or \"syslog\"."
        exit 1
        ;;
esac

#######################################################################
/bin/echo "Starting ${PROGRAM_NAME}${SYSTEMD_INSTANCE_SUFFIX}"

if [ X`whoami` = "X${USER}" ] ; then
    eval "${EXTRA_ENVVAR} exec ${PROGRAM_PATH} ${PROG_OPTIONS} ${EXTRA_OPTIONS}"
else
    exec su - ${USER} -c "${EXTRA_ENVVAR} exec ${PROGRAM_PATH} ${PROG_OPTIONS} ${EXTRA_OPTIONS}"
fi


#######################################################################
# @OPENSOURCE_LICENSE_START@
#
# SiLK 3.24
#
# Copyright 2025 Carnegie Mellon University.
#
# NO WARRANTY. THIS CARNEGIE MELLON UNIVERSITY AND SOFTWARE ENGINEERING
# INSTITUTE MATERIAL IS FURNISHED ON AN "AS-IS" BASIS. CARNEGIE MELLON
# UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER EXPRESSED OR
# IMPLIED, AS TO ANY MATTER INCLUDING, BUT NOT LIMITED TO, WARRANTY OF
# FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY, OR RESULTS
# OBTAINED FROM USE OF THE MATERIAL. CARNEGIE MELLON UNIVERSITY DOES NOT
# MAKE ANY WARRANTY OF ANY KIND WITH RESPECT TO FREEDOM FROM PATENT,
# TRADEMARK, OR COPYRIGHT INFRINGEMENT.
#
# Licensed under a GNU GPL 2.0-style license, please see LICENSE.txt or
# contact permission@sei.cmu.edu for full terms.
#
# [DISTRIBUTION STATEMENT A] This material has been approved for public
# release and unlimited distribution.  Please see Copyright notice for
# non-US Government use and distribution.
#
# This Software includes and/or makes use of Third-Party Software each
# subject to its own license.
#
# DM25-0915
#
# @OPENSOURCE_LICENSE_END@
#######################################################################
