%define name yaf
%define version 2.8.4
%define release 2

Summary: Yet Another Flow sensor
Name: %{name}
Version: %{version}
Release: %{release}%{?dist}
Group: Applications/System
License: GPLv2
Source: http://tools.netsa.cert.org/releases/%{name}-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}
Vendor: http://tools.netsa.cert.org/
URL: http://tools.netsa.cert.org/yaf/
Requires(post): /sbin/ldconfig, /sbin/chkconfig
Requires(preun): /sbin/chkconfig
Requires(postun): /sbin/ldconfig


%description
YAF is Yet Another Flow sensor. It processes packet data from pcap(3) dumpfiles
as generated by tcpdump(1) or via live capture from an interface using pcap(3)
or an Endace DAG card into bidirectional flows, then exports those flows to
IPFIX Collecting Processes or in an IPFIX-based file format. YAF's output can
be used with the SiLK tools, yafscii, and super_mediator.

%package devel
Summary: Static libraries and C header files for yaf
Group: Development/Libraries
Requires: %{name} = %{version}
Requires: pkgconfig >= 0.8

%description devel
Static libraries and C header files for yaf.

%prep
%setup -q -n %{name}-%{version}

%build
./configure --disable-static  --enable-applabel
sed -i 's|^hardcode_libdir_flag_spec=.*|hardcode_libdir_flag_spec=""|g' libtool
sed -i 's|^runpath_var=LD_RUN_PATH|runpath_var=DIE_RPATH_DIE|g' libtool
%{__make}

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT%{_bindir}
%makeinstall

mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/init.d/
install --mode=0755 etc/init.d/yaf $RPM_BUILD_ROOT%{_sysconfdir}/init.d/
install --mode=0644 etc/yaf.conf $RPM_BUILD_ROOT%{_sysconfdir}

%post                                                                           
/sbin/ldconfig
function runlvl(){
    ( /sbin/chkconfig --del $1 || true )
    /sbin/chkconfig --add $1
    /sbin/chkconfig --levels 345 $1 on
    /sbin/chkconfig --levels 016 $1 off
}

%postun -p /sbin/ldconfig

%preun
if [ "$1" = 0 ]; then
    /sbin/chkconfig --del yaf
fi

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-, root, root)
%doc AUTHORS COPYING NEWS README doc/html
%{_bindir}/yaf
%{_bindir}/yafscii
%{_bindir}/yafcollect
%{_bindir}/airdaemon
%{_bindir}/filedaemon
%{_bindir}/getFlowKeyHash
%{_bindir}/yafMeta2Pcap
%{_bindir}/ipfixDump
%{_libdir}/*.so.*
%if "x1" == "x1"
%{_libdir}/yaf/*.so*
%{_libdir}/yaf/*.la 
%endif
%{_mandir}/man*/*
%config(noreplace) %{_sysconfdir}/yafApplabelRules.conf
%if "x" == "x1"
%config(noreplace) %{_sysconfdir}/yafDPIRules.conf
%config(noreplace) %{_sysconfdir}/dhcp_fingerprints.conf
%endif
%if "x" == "x1"
%config(noreplace) %{_sysconfdir}/p0f.fp
%endif
%config(noreplace) %{_sysconfdir}/yaf.conf
%attr(755,root,root) %{_sysconfdir}/init.d/yaf 

%files devel
%defattr(-, root, root)
%{_includedir}/*
%{_libdir}/*.la
%{_libdir}/*.so
%{_libdir}/pkgconfig/*

%changelog
