% YAF Frequently Asked Questions

# [What is biflow vs uniflow?](#what-is-biflow) {#what-is-biflow}

By default, YAF exports records using "biflows" ([RFC 5103][RFC5103]
Bidirectional Flow Export using IPFIX) in which both directions of the
network traffic are represented in the flow record, usually via elements
prefixed with "reverse". If the **--uniflow** flag is given at runtime, the
flows will be split into "uniflows" (Record Adjacency method in section 3 of
RFC 5103). This can be useful when the collecting process downstream from
YAF is not biflow-aware.

[//]: # (TODO: Mention that reverse elements are in the 29305 PEN)

# [What does YAF use to determine a flow?](#determine-a-flow) {#determine-a-flow}

YAF uses the source IP, destination IP, source port, destination port,
protocol and vlan ID (unless --no-vlan-in-key is given) to figure out which
packets to group into flows. These elements are often called the "5-tuple
and vlanID". Flows will be separated even if they have the same identifying
elements based on timeouts, namely the IDLE\_TIMEOUT and ACTIVE\_TIMEOUT.
Flows are considered idle and flushed from the flow table if no packets are
received for IDLE\_TIMEOUT seconds. The default flow idle timeout is 300
seconds (5 minutes). Any flow lasting longer than ACTIVE\_TIMEOUT seconds
will be flushed from the flow table. The default flow active timeout is 1800
seconds (30 minutes).

# [What is a flowKeyHash?](#flowkeyhash) {#flowkeyhash}

The YAF flowKeyHash is a numeric value that YAF computes for every flow
record. The flow key hash is computed from the IP protocol, the source and
destination IP addresses, the source and destination ports, and the vlan
identifier. The flowKeyHash is mainly used to help quickly identify and
search for specific flows in a large collection as when taken alongside the
flow start time creates a relatively unique flow identifier.

# [How can I change the way appLabel and DPI are processed?](#applabel-and-dpi) {#applabel-and-dpi}

The behavior of both [application labeling (appLabel)][applabeling] and
[Deep Packet Inspection (DPI)][deeppacketinspection] are controlled by the
the YAF DPI rules configuration file. You can specify a configuration file
at runtime with the **--dpi-rules-file** flag or you can modify the default
file found in the default location of /usr/local/etc/yafDPIRules.conf.

# [Why is there a --silk option? Is --silk required to send data to SiLK?](#silk-option) {#silk-option}

If the **--silk** flag is present, YAF will export flows in [SiLK][] mode.
This introduces the following incompatibilities with standard IPFIX export:

-   totalOctetCount and reverseTotalOctetCount are clamped to 32 bits. Any
    packet that would cause either of these counters to overflow 32 bits
    will cause the flow to close with flowEndReason 0x02 (active timeout),
    and will become the first packet of a new flow. This is analogous to
    forcing an active timeout when the octet counters overflow.

-   The high-order bit of the flowEndReason IE is set on any flow created on
    a counter overflow, as above.

-   The high-order bit of the flowEndReason IE is set on any flow created on
    an active timeout.

Since this changes the semantics of the exported flowEndReason IE, it should
only be used when generating flows and exporting to
[**rwflowpack**][rwflowpack], [**flowcap**][flowcap], or writing files for
processing with [**rwipfix2silk**][rwipfix2silk].

The **--silk** flag is recommeneded but not required when writing to SiLK.
However without the switch, because SiLK supports only 32 bit values for the
octet and packet counts, SiLK does not properly reflect the true octet and
packet counts for flows that have values exceeding SiLK's maximum.

# [How can I read the output of YAF?](#read-yaf-output) {#read-yaf-output}

YAF outputs files using the binary IPFIX file format. These files are not
human readable as-is because the information is densely encoded to save
space. To view IPFIX files directly, it is recommended to use tools such as
[**ipfixDump**][ipfixDump] or [**ipfix2json**][ipfix2json] which are
packaged as part of the [libfixbuf][] installation.

[//]: # (Which versions are compatible with each other?)
[//]: # (TODO: This should really be like a big chart somewhere and we should just link that as the answer to this question.)


[RFC5103]:      https://tools.ietf.org/html/rfc5103

[SiLK]:                 ../silk/index.html
[libfixbuf]:            ../fixbuf/index.html
[flowcap]:              ../silk/flowcap.html
[ipfix2json]:           ../fixbuf/ipfix2json.html
[ipfixDump]:            ../fixbuf/ipfixDump.html
[rwflowpack]:           ../silk/rwflowpack.html
[rwipfix2silk]:         ../silk/rwipfix2silk.html

[applabeling]:          applabeling.html
[deeppacketinspection]: deeppacketinspection.html


[//]: # (Local variables:)
[//]: # (fill-column: 76)
[//]: # (indent-tabs-mode: nil)
[//]: # (sentence-end-double-space: nil)
[//]: # (tab-width: 8)
[//]: # (End:)
