/*
 *  Copyright 2007-2022 Carnegie Mellon University
 *  See license information in LICENSE.txt.
 */
/*
 *  yafdpi.h
 *
 *  This defines the interface to the payload scanner functions
 *
 *  ------------------------------------------------------------------------
 *  Authors: Chris Inacio
 *  ------------------------------------------------------------------------
 *  @DISTRIBUTION_STATEMENT_BEGIN@
 *  YAF 3.0.0
 *
 *  Copyright 2022 Carnegie Mellon University.
 *
 *  NO WARRANTY. THIS CARNEGIE MELLON UNIVERSITY AND SOFTWARE ENGINEERING
 *  INSTITUTE MATERIAL IS FURNISHED ON AN "AS-IS" BASIS. CARNEGIE MELLON
 *  UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER EXPRESSED OR IMPLIED,
 *  AS TO ANY MATTER INCLUDING, BUT NOT LIMITED TO, WARRANTY OF FITNESS FOR
 *  PURPOSE OR MERCHANTABILITY, EXCLUSIVITY, OR RESULTS OBTAINED FROM USE OF
 *  THE MATERIAL. CARNEGIE MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF
 *  ANY KIND WITH RESPECT TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT
 *  INFRINGEMENT.
 *
 *  Released under a GNU GPL 2.0-style license, please see license.txt or
 *  contact permission@sei.cmu.edu for full terms.
 *
 *  [DISTRIBUTION STATEMENT A] This material has been approved for public
 *  release and unlimited distribution.  Please see Copyright notice for
 *  non-US Government use and distribution.
 *
 *  Carnegie Mellon(R) and CERT(R) are registered in the U.S. Patent and
 *  Trademark Office by Carnegie Mellon University.
 *
 *  This Software includes and/or makes use of Third-Party Software subject
 *  to its own license.
 *
 *  DM22-0007
 *  @DISTRIBUTION_STATEMENT_END@
 *  ------------------------------------------------------------------------
 */



#ifndef YAFDPI_H_
#define YAFDPI_H_

#define _YAF_SOURCE_
#include <yaf/autoinc.h>
#include <yaf/yafcore.h>
#include <yaf/decode.h>


/**
 * Labels a flow's protocol according to its payload. Sets the appLabel
 * field within the flow.
 *
 * @param flow A YAF flow.
 *
 */
void
ydScanFlow(
    yfFlow_t  *flow);

void
ydAllocFlowContext(
    yfFlow_t  *flow);

void
ydFreeFlowContext(
    yfFlow_t  *flow);

void
ydInitDPI(
    gboolean    dpiEnabled,
    const char *dpiProtos,
    const char *rulesFileName);

void
ydPrintApplabelTiming(
    void);

#if YAF_ENABLE_DPI
fbInfoModel_t *
ydGetDPIInfoModel(
    void);

gboolean
ydWriteDPIList(
    fbSubTemplateList_t  *rec,
    yfFlow_t             *flow,
    GError              **err);

gboolean
ydAddDPITemplatesToSession(
    fbSession_t  *session);

void
ydFreeDPILists(
    fbSubTemplateList_t  *stl,
    yfFlow_t             *flow);
#endif  /* YAF_ENABLE_DPI */
#endif  /* ifndef YAFDPI_H_ */
