dnl Copyright 2004-2022 Carnegie Mellon University
dnl See license information in LICENSE.txt.

dnl @DISTRIBUTION_STATEMENT_BEGIN@
dnl YAF 3.0.0
dnl
dnl Copyright 2022 Carnegie Mellon University.
dnl
dnl NO WARRANTY. THIS CARNEGIE MELLON UNIVERSITY AND SOFTWARE ENGINEERING
dnl INSTITUTE MATERIAL IS FURNISHED ON AN "AS-IS" BASIS. CARNEGIE MELLON
dnl UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER EXPRESSED OR IMPLIED,
dnl AS TO ANY MATTER INCLUDING, BUT NOT LIMITED TO, WARRANTY OF FITNESS FOR
dnl PURPOSE OR MERCHANTABILITY, EXCLUSIVITY, OR RESULTS OBTAINED FROM USE OF
dnl THE MATERIAL. CARNEGIE MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF
dnl ANY KIND WITH RESPECT TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT
dnl INFRINGEMENT.
dnl
dnl Released under a GNU GPL 2.0-style license, please see license.txt or
dnl contact permission@sei.cmu.edu for full terms.
dnl
dnl [DISTRIBUTION STATEMENT A] This material has been approved for public
dnl release and unlimited distribution.  Please see Copyright notice for
dnl non-US Government use and distribution.
dnl
dnl Carnegie Mellon(R) and CERT(R) are registered in the U.S. Patent and
dnl Trademark Office by Carnegie Mellon University.
dnl
dnl This Software includes and/or makes use of Third-Party Software subject
dnl to its own license.
dnl
dnl DM22-0007
dnl @DISTRIBUTION_STATEMENT_END@

# ---------------------------------------------------------------------------
# AX_CHECK_LIBZ
#
#    Determine how to use the zlib (gzip) compression library
#
#    Substitutions: ENABLE_ZLIB
#    Output defines: YAF_ENABLE_ZLIB

AC_DEFUN([AX_CHECK_LIBZ],[
    ENABLE_ZLIB=0

    AC_ARG_WITH([zlib],[AS_HELP_STRING([--with-zlib=ZLIB_DIR],
            [specify location of the zlib file compression library; find "zlib.h" in ZLIB_DIR/include/; find "libz.so" in ZLIB_DIR/lib/ [auto]])[]dnl
        ],[
            if test "x$withval" != "xyes"
            then
                zlib_dir="$withval"
                zlib_includes="$zlib_dir/include"
                zlib_libraries="$zlib_dir/lib"
            fi
    ])
    AC_ARG_WITH([zlib-includes],[AS_HELP_STRING([--with-zlib-includes=DIR],
            [find "zlib.h" in DIR/ (overrides ZLIB_DIR/include/)])[]dnl
        ],[
            if test "x$withval" = "xno"
            then
                zlib_dir=no
            elif test "x$withval" != "xyes"
            then
                zlib_includes="$withval"
            fi
    ])
    AC_ARG_WITH([zlib-libraries],[AS_HELP_STRING([--with-zlib-libraries=DIR],
            [find "libz.so" in DIR/ (overrides ZLIB_DIR/lib/)])[]dnl
        ],[
            if test "x$withval" = "xno"
            then
                zlib_dir=no
            elif test "x$withval" != "xyes"
            then
                zlib_libraries="$withval"
            fi
    ])

    if test "x$zlib_dir" != "xno"
    then
        # Cache current values
        yf_save_LDFLAGS="$LDFLAGS"
        yf_save_LIBS="$LIBS"
        yf_save_CFLAGS="$CFLAGS"
        yf_save_CPPFLAGS="$CPPFLAGS"

        if test "x$zlib_libraries" != "x"
        then
            ZLIB_LDFLAGS="-L$zlib_libraries"
            LDFLAGS="$ZLIB_LDFLAGS $yf_save_LDFLAGS"
        fi

        if test "x$zlib_includes" != "x"
        then
            ZLIB_CFLAGS="-I$zlib_includes"
            CPPFLAGS="$ZLIB_CFLAGS $yf_save_CPPFLAGS"
        fi

        AC_CHECK_LIB([z], [gzopen],
            [ENABLE_ZLIB=1 ; ZLIB_LDFLAGS="$ZLIB_LDFLAGS -lz"])

        if test "x$ENABLE_ZLIB" = "x1"
        then
            AC_CHECK_HEADER([zlib.h], , [
                AC_MSG_WARN([Found libz but not zlib.h.  Maybe you should install zlib-devel?])
                ENABLE_ZLIB=0])
        fi

        # Restore cached values
        LDFLAGS="$yf_save_LDFLAGS"
        LIBS="$yf_save_LIBS"
        CFLAGS="$yf_save_CFLAGS"
        CPPFLAGS="$yf_save_CPPFLAGS"
    fi

    if test "x$ENABLE_ZLIB" != "x1"
    then
        ZLIB_CFLAGS=
        ZLIB_LDFLAGS=
    else
        LIBS="$LIBS $ZLIB_LDFLAGS"
        CFLAGS="$ZLIB_CFLAGS $CFLAGS"
    fi

    AC_DEFINE_UNQUOTED([YAF_ENABLE_ZLIB], [$ENABLE_ZLIB],
        [Define to 1 build with support for zlib compression.  Define
         to 0 otherwise.  Requires the libz library and the <zlib.h>
         header file.])
    AC_SUBST([ENABLE_ZLIB], [$ENABLE_ZLIB])
])# AX_CHECK_LIBZ

dnl Local Variables:
dnl mode:autoconf
dnl indent-tabs-mode:nil
dnl End:
